:setvar DatabaseName "Registry"
:setvar MajorReleaseNumber "1"
:setvar MinorReleaseNumber "0"
:setvar PointReleaseNumber "50"
:setvar DeployVersion "20150820.1"

PRINT ' 
------------------------------------------------------------------------------------------------
Step 2 - Registry.Database.Deploy.sql

Version Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

Build $(DeployVersion)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END

GO

USE [$(DatabaseName)]
GO

GO
PRINT N'Creating [AHOBPR]...';


GO
CREATE SCHEMA [AHOBPR]
    AUTHORIZATION [dbo];


GO
PRINT N'Creating [AHOBPR].[STD_CONCEPT]...';


GO
CREATE TABLE [AHOBPR].[STD_CONCEPT] (
    [STD_CONCEPT_ID]    INT            IDENTITY (1, 1) NOT NULL,
    [DESCRIPTION]       VARCHAR (4000) NOT NULL,
    [SHORT_DESCRIPTION] VARCHAR (255)  NULL,
    [CREATEDBY]         VARCHAR (30)   NOT NULL,
    [UPDATEDBY]         VARCHAR (30)   NOT NULL,
    [CREATED]           DATETIME2 (0)  NOT NULL,
    [UPDATED]           DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]       ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_CONCEPT] PRIMARY KEY CLUSTERED ([STD_CONCEPT_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_TERM]...';


GO
CREATE TABLE [AHOBPR].[STD_TERM] (
    [STD_TERM_ID]        INT            IDENTITY (1, 1) NOT NULL,
    [STD_CONCEPT_ID]     INT            NULL,
    [SYSTEM_STD_TERM_ID] INT            NULL,
    [CODE]               VARCHAR (50)   NOT NULL,
    [SHORT_DESCRIPTION]  VARCHAR (100)  NOT NULL,
    [DESCRIPTION]        VARCHAR (4000) NOT NULL,
    [CREATEDBY]          VARCHAR (30)   NOT NULL,
    [UPDATEDBY]          VARCHAR (30)   NOT NULL,
    [CREATED]            DATETIME2 (0)  NOT NULL,
    [UPDATED]            DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]        ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_CONCEPT_SYSTEM] PRIMARY KEY CLUSTERED ([STD_TERM_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[AK_STD_TERM]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_STD_TERM]
    ON [AHOBPR].[STD_TERM]([SYSTEM_STD_TERM_ID] ASC, [CODE] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE] (
    [FORM_RESPONSE_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]    INT           NOT NULL,
    [STD_FORM_ID]      INT           NOT NULL,
    [CREATEDBY]        VARCHAR (30)  NOT NULL,
    [UPDATEDBY]        VARCHAR (30)  NOT NULL,
    [CREATED]          DATETIME2 (0) NOT NULL,
    [UPDATED]          DATETIME2 (0) NOT NULL,
    [ROW_VERSION]      ROWVERSION    NOT NULL,
    CONSTRAINT [PK_FORM_RESPONSE] PRIMARY KEY CLUSTERED ([FORM_RESPONSE_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[IX_FormResponse_RegistrantId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FormResponse_RegistrantId]
    ON [AHOBPR].[FORM_RESPONSE]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[IX_FormResponse_StdFormId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FormResponse_StdFormId]
    ON [AHOBPR].[FORM_RESPONSE]([STD_FORM_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] (
    [FORM_RESPONSE_ANSWER_ID]   INT            IDENTITY (1, 1) NOT NULL,
    [FORM_RESPONSE_QUESTION_ID] INT            NOT NULL,
    [STD_FORM_ANSWER_ID]        INT            NOT NULL,
    [ANSWER_VALUE]              VARCHAR (4000) NULL,
    [CREATEDBY]                 VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                 VARCHAR (30)   NOT NULL,
    [CREATED]                   DATETIME2 (0)  NOT NULL,
    [UPDATED]                   DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]               ROWVERSION     NOT NULL,
    CONSTRAINT [PK_FORM_RESPONSE_ANSWER] PRIMARY KEY CLUSTERED ([FORM_RESPONSE_ANSWER_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[IX_FormResponseAnswer_FormResponseDetailId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FormResponseAnswer_FormResponseDetailId]
    ON [AHOBPR].[FORM_RESPONSE_ANSWER]([FORM_RESPONSE_QUESTION_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[IX_FormResponseAnswer_StdFormAnswerId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FormResponseAnswer_StdFormAnswerId]
    ON [AHOBPR].[FORM_RESPONSE_ANSWER]([STD_FORM_ANSWER_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_STATUS]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_STATUS] (
    [FORM_RESPONSE_STATUS_ID]      INT           IDENTITY (1, 1) NOT NULL,
    [FORM_RESPONSE_ID]             INT           NOT NULL,
    [LAST_SECTION_ID]              INT           NULL,
    [LAST_SUB_SECTION_ID]          INT           NULL,
    [QUESTIONNAIRE_STARTED_DATE]   DATETIME2 (0) NOT NULL,
    [QUESTIONNAIRE_COMPLETED_DATE] DATETIME2 (0) NULL,
    [CREATEDBY]                    VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                    VARCHAR (30)  NOT NULL,
    [CREATED]                      DATETIME2 (0) NOT NULL,
    [UPDATED]                      DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                  ROWVERSION    NOT NULL,
    CONSTRAINT [PK_FORM_RESPONSE_STATUS] PRIMARY KEY CLUSTERED ([FORM_RESPONSE_STATUS_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[PROCESS_METRICS]...';


GO
CREATE TABLE [AHOBPR].[PROCESS_METRICS] (
    [PROCESS_METRICS_ID]          INT            IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]               INT            NOT NULL,
    [STD_PROCESS_METRICS_TYPE_ID] INT            NOT NULL,
    [PROCESS_METRICS_VALUE]       VARCHAR (1000) NOT NULL,
    [CREATEDBY]                   VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)   NOT NULL,
    [CREATED]                     DATETIME2 (0)  NOT NULL,
    [UPDATED]                     DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                 ROWVERSION     NOT NULL,
    CONSTRAINT [PROCESS_METRICS_ID_PK] PRIMARY KEY CLUSTERED ([PROCESS_METRICS_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM] (
    [STD_FORM_ID] INT           IDENTITY (1, 1) NOT NULL,
    [NAME]        VARCHAR (256) NOT NULL,
    [VERSION]     VARCHAR (50)  NOT NULL,
    [TITLE]       VARCHAR (500) NULL,
    [OMB]         VARCHAR (500) NULL,
    [BPR_FORM_ID] VARCHAR (50)  NULL,
    [CREATEDBY]   VARCHAR (30)  NOT NULL,
    [UPDATEDBY]   VARCHAR (30)  NOT NULL,
    [CREATED]     DATETIME2 (0) NOT NULL,
    [UPDATED]     DATETIME2 (0) NOT NULL,
    [ROW_VERSION] ROWVERSION    NOT NULL,
    CONSTRAINT [PK_BPRFORMSCHEMA] PRIMARY KEY CLUSTERED ([STD_FORM_ID] ASC) ON [AHOBPR],
    CONSTRAINT [UK_BPR_FORM_ID] UNIQUE NONCLUSTERED ([BPR_FORM_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_ANSWER] (
    [STD_FORM_ANSWER_ID]      INT            IDENTITY (1, 1) NOT NULL,
    [STD_FORM_QUESTION_ID]    INT            NOT NULL,
    [STD_FORM_SUB_SECTION_ID] INT            NOT NULL,
    [STD_FORM_SECTION_ID]     INT            NOT NULL,
    [STD_FORM_ID]             INT            NOT NULL,
    [ORDER]                   INT            NOT NULL,
    [TEXT]                    VARCHAR (4000) NULL,
    [EDITABLE]                BIT            NOT NULL,
    [HELP]                    VARCHAR (1000) NOT NULL,
    [CLINICAL_RELEVANT_FLAG]  BIT            NOT NULL,
    [BRP_FORM_ANSWER_ID]      VARCHAR (100)  NULL,
    [BRP_FORM_QUESTION_ID]    VARCHAR (100)  NULL,
    [CREATEDBY]               VARCHAR (30)   NOT NULL,
    [UPDATEDBY]               VARCHAR (30)   NOT NULL,
    [CREATED]                 DATETIME2 (0)  NOT NULL,
    [UPDATED]                 DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]             ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_FORM_ANSWER] PRIMARY KEY CLUSTERED ([STD_FORM_ANSWER_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER_FIELD]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD] (
    [STD_FORM_ANSWER_FIELD_ID] INT           IDENTITY (1, 1) NOT NULL,
    [STD_FORM_ANSWER_ID]       INT           NOT NULL,
    [LABEL]                    VARCHAR (500) NOT NULL,
    [MIN]                      VARCHAR (500) NULL,
    [MAX]                      VARCHAR (500) NULL,
    [CREATEDBY]                VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                VARCHAR (30)  NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    [UPDATED]                  DATETIME2 (0) NOT NULL,
    [ROW_VERSION]              ROWVERSION    NOT NULL,
    CONSTRAINT [PK_STD_FORM_ANSWER_FIELD] PRIMARY KEY CLUSTERED ([STD_FORM_ANSWER_FIELD_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_SECTION] (
    [STD_FORM_SECTION_ID] INT            IDENTITY (1, 1) NOT NULL,
    [STD_FORM_ID]         INT            NOT NULL,
    [TITLE]               VARCHAR (255)  NULL,
    [INTRODUCTION]        VARCHAR (4000) NULL,
    [CONCLUSION]          VARCHAR (4000) NULL,
    [DESCRIPTION]         VARCHAR (4000) NULL,
    [NOTES]               TEXT           NULL,
    [LINE_NUMBER]         INT            NULL,
    [BRP_FORM_SECTION_ID] INT            NULL,
    [MENU_ITEM_NAME]      VARCHAR (100)  NULL,
    [TOOL_TIP]            VARCHAR (255)  NULL,
    [CREATEDBY]           VARCHAR (30)   NOT NULL,
    [UPDATEDBY]           VARCHAR (30)   NOT NULL,
    [CREATED]             DATETIME2 (0)  NOT NULL,
    [UPDATED]             DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]         ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_FORM_SECTION] PRIMARY KEY CLUSTERED ([STD_FORM_SECTION_ID] ASC) ON [AHOBPR]
) TEXTIMAGE_ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_SUB_SECTION] (
    [STD_FORM_SUB_SECTION_ID] INT            IDENTITY (1, 1) NOT NULL,
    [STD_FORM_SECTION_ID]     INT            NOT NULL,
    [STD_FORM_ID]             INT            NOT NULL,
    [TITLE]                   VARCHAR (255)  NULL,
    [INTRODUCTION]            VARCHAR (4000) NULL,
    [CONCLUSION]              VARCHAR (4000) NULL,
    [BRP_FORM_SUB_SECTION_ID] INT            NULL,
    [MENU_ITEM_NAME]          VARCHAR (100)  NULL,
    [TOOL_TIP]                VARCHAR (255)  NULL,
    [CREATEDBY]               VARCHAR (30)   NOT NULL,
    [UPDATEDBY]               VARCHAR (30)   NOT NULL,
    [CREATED]                 DATETIME2 (0)  NOT NULL,
    [UPDATED]                 DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]             ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_FORM_SUB_SECTION] PRIMARY KEY CLUSTERED ([STD_FORM_SUB_SECTION_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_PROCESS_METRICS_TYPE]...';


GO
CREATE TABLE [AHOBPR].[STD_PROCESS_METRICS_TYPE] (
    [STD_PROCESS_METRICS_TYPE_ID] INT           IDENTITY (1, 1) NOT NULL,
    [PROCESS_METRICS]             VARCHAR (256) NOT NULL,
    [CREATEDBY]                   VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)  NOT NULL,
    [CREATED]                     DATETIME2 (0) NOT NULL,
    [UPDATED]                     DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                 ROWVERSION    NOT NULL,
    CONSTRAINT [STD_PROCESS_METRICS_TYPE_PK] PRIMARY KEY CLUSTERED ([STD_PROCESS_METRICS_TYPE_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS]...';


GO
CREATE TABLE [AHOBPR].[STD_REGISTRANT_STATUS] (
    [STD_REGISTRANT_STATUS_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_STATUS]        VARCHAR (100) NOT NULL,
    [ORDINAL_VALUE]            TINYINT       NOT NULL,
    [CREATEDBY]                VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                VARCHAR (30)  NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    [UPDATED]                  DATETIME2 (0) NOT NULL,
    [ROW_VERSION]              ROWVERSION    NOT NULL,
    CONSTRAINT [STD_REGISTRANT_STATUS_PK] PRIMARY KEY CLUSTERED ([STD_REGISTRANT_STATUS_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[AK_STD_REGISTRANT_STATUS]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_STD_REGISTRANT_STATUS]
    ON [AHOBPR].[STD_REGISTRANT_STATUS]([REGISTRANT_STATUS] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG]...';


GO
CREATE TABLE [AHOBPR].[STD_REGISTRY_FLAG] (
    [STD_REGISTRY_FLAG_ID]      INT            IDENTITY (1, 1) NOT NULL,
    [REGISTRY_FLAG_NAME]        VARCHAR (100)  NOT NULL,
    [REGISTRY_FLAG_DESCRIPTION] VARCHAR (1000) NULL,
    [STD_REGISTRY_FLAG_TYPE_ID] INT            NOT NULL,
    [ACTIVE_FLAG]               BIT            NOT NULL,
    [PREDEFINED]                BIT            NOT NULL,
    [CREATEDBY]                 VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                 VARCHAR (30)   NOT NULL,
    [CREATED]                   DATETIME2 (0)  NOT NULL,
    [UPDATED]                   DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]               ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_REGISTRY_FLAG] PRIMARY KEY CLUSTERED ([STD_REGISTRY_FLAG_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[AK_StdRegistryFlag_Name]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_StdRegistryFlag_Name]
    ON [AHOBPR].[STD_REGISTRY_FLAG]([REGISTRY_FLAG_NAME] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[IX_StdRegistryFlag_StdRegistryFlagType]...';


GO
CREATE NONCLUSTERED INDEX [IX_StdRegistryFlag_StdRegistryFlagType]
    ON [AHOBPR].[STD_REGISTRY_FLAG]([STD_REGISTRY_FLAG_TYPE_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS]...';


GO
CREATE TABLE [AHOBPR].[STD_SERVICE_STATUS] (
    [STD_SERVICE_STATUS_ID] INT           IDENTITY (1, 1) NOT NULL,
    [SERVICE_STATUS]        VARCHAR (100) NOT NULL,
    [CREATEDBY]             VARCHAR (30)  NOT NULL,
    [UPDATEDBY]             VARCHAR (30)  NOT NULL,
    [CREATED]               DATETIME2 (0) NOT NULL,
    [UPDATED]               DATETIME2 (0) NOT NULL,
    [ROW_VERSION]           ROWVERSION    NOT NULL,
    CONSTRAINT [STD_SERVICE_STATUS_PK] PRIMARY KEY CLUSTERED ([STD_SERVICE_STATUS_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS].[AK_STD_SERVICE_STATUS]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_STD_SERVICE_STATUS]
    ON [AHOBPR].[STD_SERVICE_STATUS]([SERVICE_STATUS] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG_TYPE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_REGISTRY_FLAG_TYPE] (
    [STD_REGISTRY_FLAG_TYPE_ID]      INT            IDENTITY (1, 1) NOT NULL,
    [REGISTRY_FLAG_TYPE]             VARCHAR (100)  NOT NULL,
    [REGISTRY_FLAG_TYPE_DESCRIPTION] VARCHAR (1000) NULL,
    [CREATEDBY]                      VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                      VARCHAR (30)   NOT NULL,
    [CREATED]                        DATETIME2 (0)  NOT NULL,
    [UPDATED]                        DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                    ROWVERSION     NOT NULL,
    [ACTIVE_FLAG]                    BIT            NOT NULL,
    CONSTRAINT [PK_STD_REGISTRY_FLAG_TYPE] PRIMARY KEY CLUSTERED ([STD_REGISTRY_FLAG_TYPE_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] (
    [REGISTRANT_REGISTRY_FLAG_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]               INT           NOT NULL,
    [STD_REGISTRY_FLAG_ID]        INT           NOT NULL,
    [CREATEDBY]                   VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)  NOT NULL,
    [CREATED]                     DATETIME2 (0) NOT NULL,
    [UPDATED]                     DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                 ROWVERSION    NOT NULL,
    CONSTRAINT [PK_REGISTRANT_REGISTRY_FLAG] PRIMARY KEY CLUSTERED ([REGISTRANT_REGISTRY_FLAG_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG].[IX_RegistrantRegistryFlag_RegistrantId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantRegistryFlag_RegistrantId]
    ON [AHOBPR].[REGISTRANT_REGISTRY_FLAG]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG].[IX_RegistrantRegistryFlag_StdRegistryFlagId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantRegistryFlag_StdRegistryFlagId]
    ON [AHOBPR].[REGISTRANT_REGISTRY_FLAG]([STD_REGISTRY_FLAG_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_EMAIL] (
    [REGISTRANT_EMAIL_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]       INT           NOT NULL,
    [TYPE]                VARCHAR (100) NULL,
    [EMAIL]               VARCHAR (256) NULL,
    [CREATEDBY]           VARCHAR (30)  NOT NULL,
    [UPDATEDBY]           VARCHAR (30)  NOT NULL,
    [CREATED]             DATETIME2 (0) NOT NULL,
    [UPDATED]             DATETIME2 (0) NOT NULL,
    [ROW_VERSION]         ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_EMAIL_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_EMAIL_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[IX_RegistrantEmail_RegistrantContactInfoId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantEmail_RegistrantContactInfoId]
    ON [AHOBPR].[REGISTRANT_EMAIL]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] (
    [REGISTRANT_DEPLOYMENT_ID]  INT            IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]             INT            NOT NULL,
    [STD_BRANCH_OF_SERVICE_ID]  INT            NULL,
    [DUTY_PROJECT_CODE]         VARCHAR (100)  NULL,
    [STD_SERVICE_OCCUPATION_ID] INT            NULL,
    [MILITARY_RANK]             VARCHAR (50)   NULL,
    [DEPLOYMENT_UIC]            CHAR (6)       NULL,
    [DEPLOYMENT_COUNTRY]        VARCHAR (100)  NULL,
    [DEPLOYMENT_BASE]           VARCHAR (255)  NULL,
    [DEPLOYMENT_START_DATE]     DATETIME2 (0)  NULL,
    [DEPLOYMENT_END_DATE]       DATETIME2 (0)  NULL,
    [IS_GULF_WAR_VETERAN_FLAG]  BIT            NULL,
    [IS_ELIGIBLE_FLAG]          BIT            NULL,
    [USER_ENTERED_FLAG]         BIT            NULL,
    [USER_VERIFIED_FLAG]        BIT            NULL,
    [LAST_UPDATED_DATE]         DATETIME2 (0)  NULL,
    [PREVIOUS_VALUES]           VARCHAR (4000) NULL,
    [PREVIOUS_UPDATED_DATE]     DATETIME2 (0)  NULL,
    [BPR_DEPLOYMENT_ID]         VARCHAR (50)   NULL,
    [STD_COMPONENT_ID]          INT            NULL,
    [CREATEDBY]                 VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                 VARCHAR (30)   NOT NULL,
    [CREATED]                   DATETIME2 (0)  NOT NULL,
    [UPDATED]                   DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]               ROWVERSION     NOT NULL,
    CONSTRAINT [PK_REGISTRANT_DEPLOYMENT] PRIMARY KEY CLUSTERED ([REGISTRANT_DEPLOYMENT_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[IX_RegistrantDeploymentHistory_RegistryId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantDeploymentHistory_RegistryId]
    ON [AHOBPR].[REGISTRANT_DEPLOYMENT]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[IX_RegistrantDeploymentHistory_StdBranchOfServiceId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantDeploymentHistory_StdBranchOfServiceId]
    ON [AHOBPR].[REGISTRANT_DEPLOYMENT]([STD_BRANCH_OF_SERVICE_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO] (
    [REGISTRANT_ID]         INT           NOT NULL,
    [FIRST_NAME_CONFIRMED]  VARCHAR (50)  NULL,
    [MIDDLE_NAME_CONFIRMED] VARCHAR (50)  NULL,
    [LAST_NAME_CONFIRMED]   VARCHAR (50)  NULL,
    [LAST_UPDATED_DATE]     DATETIME2 (0) NULL,
    [PREVIOUS_VALUES]       VARCHAR (MAX) NULL,
    [PREVIOUS_UPDATED_DATE] DATETIME2 (0) NULL,
    [CREATEDBY]             VARCHAR (30)  NOT NULL,
    [UPDATEDBY]             VARCHAR (30)  NOT NULL,
    [CREATED]               DATETIME2 (0) NOT NULL,
    [UPDATED]               DATETIME2 (0) NOT NULL,
    [ROW_VERSION]           ROWVERSION    NOT NULL,
    CONSTRAINT [PK_REGISTRANT_CONTACT_INFO_ID] PRIMARY KEY CLUSTERED ([REGISTRANT_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO].[IX_RegistrantContactInfo_RegistrantInfoId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantContactInfo_RegistrantInfoId]
    ON [AHOBPR].[REGISTRANT_CONTACT_INFO]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_ADDRESS] (
    [REGISTRANT_ADDRESS_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]         INT           NOT NULL,
    [TYPE]                  VARCHAR (100) NULL,
    [STREET1]               VARCHAR (256) NULL,
    [STREET2]               VARCHAR (256) NULL,
    [CITY]                  VARCHAR (100) NULL,
    [STATE]                 VARCHAR (100) NULL,
    [ZIP]                   VARCHAR (15)  NULL,
    [COUNTRY]               VARCHAR (100) NULL,
    [CREATEDBY]             VARCHAR (30)  NOT NULL,
    [UPDATEDBY]             VARCHAR (30)  NOT NULL,
    [CREATED]               DATETIME2 (0) NOT NULL,
    [UPDATED]               DATETIME2 (0) NOT NULL,
    [ROW_VERSION]           ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_ADDRESS_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_ADDRESS_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[IX_RegistrantAddress_RegistrantContactInfoId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantAddress_RegistrantContactInfoId]
    ON [AHOBPR].[REGISTRANT_ADDRESS]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] (
    [STD_HEALTH_FACTOR_CATEGORY_ID] TINYINT        IDENTITY (1, 1) NOT NULL,
    [NAME]                          VARCHAR (50)   NOT NULL,
    [DESCRIPTION]                   VARCHAR (4000) NULL,
    [ACTIVE_FLAG]                   BIT            NOT NULL,
    [CREATEDBY]                     VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                     VARCHAR (30)   NOT NULL,
    [CREATED]                       DATETIME2 (0)  NOT NULL,
    [UPDATED]                       DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                   ROWVERSION     NOT NULL,
    [TOOLTIP]                       VARCHAR (200)  NULL,
    CONSTRAINT [PK_STD_HEALTH_FACTOR_CATEGORY] PRIMARY KEY CLUSTERED ([STD_HEALTH_FACTOR_CATEGORY_ID] ASC)
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[AK_STD_HEALTH_FACTOR_CATEGORY]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_STD_HEALTH_FACTOR_CATEGORY]
    ON [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]([NAME] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_HEALTH_FACTOR] (
    [STD_HEALTH_FACTOR_ID]          SMALLINT       IDENTITY (1, 1) NOT NULL,
    [NAME]                          VARCHAR (50)   NOT NULL,
    [DESCRIPTION]                   VARCHAR (4000) NULL,
    [STD_HEALTH_FACTOR_CATEGORY_ID] TINYINT        NULL,
    [ACTIVE_FLAG]                   BIT            NOT NULL,
    [CREATEDBY]                     VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                     VARCHAR (30)   NOT NULL,
    [CREATED]                       DATETIME2 (0)  NOT NULL,
    [UPDATED]                       DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                   ROWVERSION     NOT NULL,
    [SORT_ORDER]                    INT            NULL,
    CONSTRAINT [PK_STD_HEALTH_FACTOR] PRIMARY KEY CLUSTERED ([STD_HEALTH_FACTOR_ID] ASC)
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[AK_StdHealthFactor_Name]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_StdHealthFactor_Name]
    ON [AHOBPR].[STD_HEALTH_FACTOR]([NAME] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] (
    [REGISTRANT_HEALTH_FACTOR_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_VISIT_ID]         INT           NULL,
    [STD_HEALTH_FACTOR_ID]        SMALLINT      NULL,
    [ACTIVE_FLAG]                 BIT           NOT NULL,
    [COMMENTS]                    VARCHAR (255) NULL,
    [HEALTH_FACTOR_TEXT]          VARCHAR (40)  NULL,
    [CREATEDBY]                   VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)  NOT NULL,
    [CREATED]                     DATETIME2 (0) NOT NULL,
    [UPDATED]                     DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                 ROWVERSION    NOT NULL,
    CONSTRAINT [PK_REGISTRANT_HEALTH_FACTOR] PRIMARY KEY CLUSTERED ([REGISTRANT_HEALTH_FACTOR_ID] ASC)
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REPORT_SEARCH_CRITERIA]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REPORT_SEARCH_CRITERIA] (
    [REPORT_SEARCH_CRITERIA_ID]   INT            IDENTITY (1, 1) NOT NULL,
    [REPORT_NAME]                 VARCHAR (100)  NOT NULL,
    [SEARCH_CRITERIA_NAME]        VARCHAR (256)  NOT NULL,
    [SEARCH_CRITERIA]             VARCHAR (4000) NOT NULL,
    [SEARCH_CRITERIA_DESCRIPTION] VARCHAR (4000) NOT NULL,
    [CREATEDBY]                   VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)   NOT NULL,
    [CREATED]                     DATETIME2 (0)  NOT NULL,
    [UPDATED]                     DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                 ROWVERSION     NOT NULL,
    CONSTRAINT [REPORT_SEARCH_CRITERIA_PK] PRIMARY KEY CLUSTERED ([REPORT_SEARCH_CRITERIA_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[ERROR_LOG]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[ERROR_LOG] (
    [ERROR_LOG_ID]   INT           IDENTITY (1, 1) NOT NULL,
    [COMPONENT_TYPE] VARCHAR (100) NOT NULL,
    [ERROR_TYPE]     VARCHAR (100) NOT NULL,
    [ERROR_SOURCE]   VARCHAR (200) NOT NULL,
    [ERROR_MESSAGE]  VARCHAR (MAX) NOT NULL,
    [CREATEDBY]      VARCHAR (30)  NOT NULL,
    [UPDATEDBY]      VARCHAR (30)  NOT NULL,
    [CREATED]        DATETIME2 (0) NOT NULL,
    [UPDATED]        DATETIME2 (0) NOT NULL,
    [ROW_VERSION]    ROWVERSION    NOT NULL,
    CONSTRAINT [ERROR_LOG_PK] PRIMARY KEY CLUSTERED ([ERROR_LOG_ID] ASC) ON [AHOBPR]
) ON [AHOBPR] TEXTIMAGE_ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_DEPLOYMENT_LOCATION]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_DEPLOYMENT_LOCATION] (
    [STD_DEPLOYMENT_LOCATION_ID] INT           IDENTITY (1, 1) NOT NULL,
    [BASE]                       VARCHAR (100) NULL,
    [COUNTRY]                    VARCHAR (200) NULL,
    [OTHER_NAMES]                VARCHAR (200) NULL,
    [NAMES]                      VARCHAR (100) NULL,
    [PROVINCE]                   VARCHAR (200) NULL,
    [USER_ADDED_FLAG]            BIT           NOT NULL,
    [CREATEDBY]                  VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                  VARCHAR (30)  NOT NULL,
    [CREATED]                    DATETIME2 (0) NOT NULL,
    [UPDATED]                    DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                ROWVERSION    NOT NULL,
    CONSTRAINT [STD_DEPLOYMENT_LOCATION_PK] PRIMARY KEY CLUSTERED ([STD_DEPLOYMENT_LOCATION_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_BRANCH_OF_SERVICE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_BRANCH_OF_SERVICE] (
    [STD_BRANCH_OF_SERVICE_ID] INT           IDENTITY (1, 1) NOT NULL,
    [BRANCH_OF_SERVICE]        VARCHAR (100) NOT NULL,
    [CREATEDBY]                VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                VARCHAR (30)  NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    [UPDATED]                  DATETIME2 (0) NOT NULL,
    [ROW_VERSION]              ROWVERSION    NOT NULL,
    CONSTRAINT [STD_BRANCH_OF_SERVICE_PK] PRIMARY KEY CLUSTERED ([STD_BRANCH_OF_SERVICE_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_SERVICE_EPISODE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] (
    [REGISTRANT_SERVICE_EPISODE_ID]      INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]                      INT           NOT NULL,
    [STD_BRANCH_OF_SERVICE_ID]           INT           NULL,
    [BRANCH_OF_SERVICE_TEXT]             VARCHAR (255) NULL,
    [SERVICE_EPISODE_START_DATE]         DATE          NULL,
    [SERVICE_EPISODE_END_DATE]           DATE          NULL,
    [SERVICE_EPISODE_TERMINATION_REASON] VARCHAR (500) NULL,
    [ACTIVATION_END_DATE]                DATE          NULL,
    [CREATEDBY]                          VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                          VARCHAR (30)  NOT NULL,
    [CREATED]                            DATETIME2 (0) NOT NULL,
    [UPDATED]                            DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                        ROWVERSION    NOT NULL,
    CONSTRAINT [PK_REGISTRANT_SERVICE_EPISODE] PRIMARY KEY CLUSTERED ([REGISTRANT_SERVICE_EPISODE_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_RECORD_INFO] (
    [REGISTRANT_ID]              INT           NOT NULL,
    [EULA_ACCEPTED_DATE]         DATETIME2 (0) NULL,
    [EDIPI_VERIFIED_DATE]        DATETIME2 (0) NULL,
    [EDIPI_MISMATCHED_FLAG]      BIT           NULL,
    [CONTACT_INFO_VERIFIED_DATE] DATETIME2 (0) NULL,
    [CREATEDBY]                  VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                  VARCHAR (30)  NOT NULL,
    [CREATED]                    DATETIME2 (0) NOT NULL,
    [UPDATED]                    DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_INFO_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO].[IX_RegistrantInfo_RegistrantId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantInfo_RegistrantId]
    ON [AHOBPR].[REGISTRANT_RECORD_INFO]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[EMAIL_TEMPLATES]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[EMAIL_TEMPLATES] (
    [TEMPLATE_ID] INT            IDENTITY (1, 1) NOT NULL,
    [TITLE]       VARCHAR (255)  NOT NULL,
    [SUBJECT]     VARCHAR (255)  NOT NULL,
    [BODY]        VARCHAR (2000) NOT NULL,
    [ACTIVE]      BIT            NOT NULL,
    [CREATEDBY]   VARCHAR (30)   NOT NULL,
    [UPDATEDBY]   VARCHAR (30)   NOT NULL,
    [CREATED]     DATETIME2 (0)  NOT NULL,
    [UPDATED]     DATETIME2 (0)  NOT NULL,
    [ROW_VERSION] TIMESTAMP      NOT NULL,
    CONSTRAINT [PK_EMAIL_TEMPLATES] PRIMARY KEY CLUSTERED ([TEMPLATE_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[EMAIL_LOG]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[EMAIL_LOG] (
    [EMAIL_ID]      INT            IDENTITY (1, 1) NOT NULL,
    [TEMPLATE_ID]   INT            NOT NULL,
    [REGISTRANT_ID] INT            NOT NULL,
    [USER_ID]       INT            NULL,
    [EMAIL_SENT]    DATETIME2 (0)  NULL,
    [EMAIL_TO]      VARCHAR (255)  NULL,
    [EMAIL_CC]      VARCHAR (255)  NULL,
    [EMAIL_BCC]     VARCHAR (255)  NULL,
    [SUBJECT]       VARCHAR (255)  NULL,
    [BODY]          VARCHAR (2000) NULL,
    [FAILED]        VARCHAR (MAX)  NULL,
    [CREATEDBY]     VARCHAR (30)   NOT NULL,
    [UPDATEDBY]     VARCHAR (30)   NOT NULL,
    [CREATED]       DATETIME2 (0)  NOT NULL,
    [UPDATED]       DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]   ROWVERSION     NOT NULL,
    CONSTRAINT [PK_EMAIL_LOG] PRIMARY KEY CLUSTERED ([EMAIL_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER_H]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_ANSWER_H] (
    [Audit_FORM_RESPONSE_ANSWER_H_ID] INT            IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                      DATETIME       NOT NULL,
    [Audit_Type]                      VARCHAR (20)   NOT NULL,
    [Audit_ApplicationUser]           VARCHAR (128)  NULL,
    [Audit_SQLUser]                   VARCHAR (100)  NULL,
    [FORM_RESPONSE_ANSWER_ID]         INT            NULL,
    [FORM_RESPONSE_QUESTION_ID]       INT            NULL,
    [STD_FORM_ANSWER_ID]              INT            NULL,
    [ANSWER_VALUE]                    VARCHAR (4000) NULL,
    [CREATEDBY]                       VARCHAR (30)   NULL,
    [UPDATEDBY]                       VARCHAR (30)   NULL,
    [CREATED]                         DATETIME2 (7)  NULL,
    [UPDATED]                         DATETIME2 (7)  NULL,
    CONSTRAINT [FORM_RESPONSE_ANSWER_H_PK] PRIMARY KEY CLUSTERED ([Audit_FORM_RESPONSE_ANSWER_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_H]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_H] (
    [Audit_FORM_RESPONSE_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]               DATETIME      NOT NULL,
    [Audit_Type]               VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]    VARCHAR (128) NULL,
    [Audit_SQLUser]            VARCHAR (100) NULL,
    [FORM_RESPONSE_ID]         INT           NULL,
    [REGISTRANT_ID]            INT           NULL,
    [STD_FORM_ID]              INT           NULL,
    [CREATEDBY]                VARCHAR (30)  NULL,
    [UPDATEDBY]                VARCHAR (30)  NULL,
    [CREATED]                  DATETIME2 (7) NULL,
    [UPDATED]                  DATETIME2 (7) NULL,
    CONSTRAINT [FORM_RESPONSE_H_PK] PRIMARY KEY CLUSTERED ([Audit_FORM_RESPONSE_H_ID] ASC)
) ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION_H]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_QUESTION_H] (
    [Audit_FORM_RESPONSE_QUESTION_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                        DATETIME      NOT NULL,
    [Audit_Type]                        VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]             VARCHAR (128) NULL,
    [Audit_SQLUser]                     VARCHAR (100) NULL,
    [FORM_RESPONSE_QUESTION_ID]         INT           NULL,
    [FORM_RESPONSE_ID]                  INT           NULL,
    [STD_FORM_QUESTION_ID]              INT           NULL,
    [REGISTRANT_DEPLOYMENT_ID]          INT           NULL,
    [STARTED_DATE]                      DATETIME2 (7) NULL,
    [COMPLETED_DATE]                    DATETIME2 (7) NULL,
    [CREATEDBY]                         VARCHAR (30)  NULL,
    [UPDATEDBY]                         VARCHAR (30)  NULL,
    [CREATED]                           DATETIME2 (7) NULL,
    [UPDATED]                           DATETIME2 (7) NULL,
    CONSTRAINT [FORM_RESPONSE_QUESTION_H_PK] PRIMARY KEY CLUSTERED ([Audit_FORM_RESPONSE_QUESTION_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_STATUS_H]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_STATUS_H] (
    [Audit_FORM_RESPONSE_STATUS_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                      DATETIME      NOT NULL,
    [Audit_Type]                      VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]           VARCHAR (128) NULL,
    [Audit_SQLUser]                   VARCHAR (100) NULL,
    [FORM_RESPONSE_STATUS_ID]         INT           NULL,
    [FORM_RESPONSE_ID]                INT           NULL,
    [LAST_SECTION_ID]                 INT           NULL,
    [LAST_SUB_SECTION_ID]             INT           NULL,
    [QUESTIONNAIRE_STARTED_DATE]      DATETIME2 (7) NULL,
    [QUESTIONNAIRE_COMPLETED_DATE]    DATETIME2 (7) NULL,
    [CREATEDBY]                       VARCHAR (30)  NULL,
    [UPDATEDBY]                       VARCHAR (30)  NULL,
    [CREATED]                         DATETIME2 (7) NULL,
    [UPDATED]                         DATETIME2 (7) NULL,
    CONSTRAINT [FORM_RESPONSE_STATUS_H_PK] PRIMARY KEY CLUSTERED ([Audit_FORM_RESPONSE_STATUS_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_ADDRESS_H] (
    [Audit_REGISTRANT_ADDRESS_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                    DATETIME      NOT NULL,
    [Audit_Type]                    VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]         VARCHAR (128) NULL,
    [Audit_SQLUser]                 VARCHAR (100) NULL,
    [REGISTRANT_ADDRESS_ID]         INT           NULL,
    [REGISTRANT_ID]                 INT           NULL,
    [TYPE]                          VARCHAR (100) NULL,
    [STREET1]                       VARCHAR (256) NULL,
    [STREET2]                       VARCHAR (256) NULL,
    [CITY]                          VARCHAR (100) NULL,
    [STATE]                         VARCHAR (100) NULL,
    [ZIP]                           VARCHAR (15)  NULL,
    [COUNTRY]                       VARCHAR (100) NULL,
    [CREATEDBY]                     VARCHAR (30)  NULL,
    [UPDATEDBY]                     VARCHAR (30)  NULL,
    [CREATED]                       DATETIME2 (7) NULL,
    [UPDATED]                       DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_ADDRESS_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_ADDRESS_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO_H] (
    [Audit_REGISTRANT_CONTACT_INFO_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                         DATETIME      NOT NULL,
    [Audit_Type]                         VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]              VARCHAR (128) NULL,
    [Audit_SQLUser]                      VARCHAR (100) NULL,
    [REGISTRANT_ID]                      INT           NULL,
    [FIRST_NAME_CONFIRMED]               VARCHAR (50)  NULL,
    [MIDDLE_NAME_CONFIRMED]              VARCHAR (50)  NULL,
    [LAST_NAME_CONFIRMED]                VARCHAR (50)  NULL,
    [LAST_UPDATED_DATE]                  DATETIME2 (7) NULL,
    [PREVIOUS_VALUES]                    VARCHAR (MAX) NULL,
    [PREVIOUS_UPDATED_DATE]              DATETIME2 (7) NULL,
    [CREATEDBY]                          VARCHAR (30)  NULL,
    [UPDATEDBY]                          VARCHAR (30)  NULL,
    [CREATED]                            DATETIME2 (7) NULL,
    [UPDATED]                            DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_CONTACT_INFO_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_CONTACT_INFO_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_EMAIL_H] (
    [Audit_REGISTRANT_EMAIL_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                  DATETIME      NOT NULL,
    [Audit_Type]                  VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]       VARCHAR (128) NULL,
    [Audit_SQLUser]               VARCHAR (100) NULL,
    [REGISTRANT_EMAIL_ID]         INT           NULL,
    [REGISTRANT_ID]               INT           NULL,
    [TYPE]                        VARCHAR (100) NULL,
    [EMAIL]                       VARCHAR (256) NULL,
    [CREATEDBY]                   VARCHAR (30)  NULL,
    [UPDATEDBY]                   VARCHAR (30)  NULL,
    [CREATED]                     DATETIME2 (7) NULL,
    [UPDATED]                     DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_EMAIL_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_EMAIL_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_H] (
    [Audit_REGISTRANT_H_ID]                  INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                             DATETIME      NOT NULL,
    [Audit_Type]                             VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]                  VARCHAR (128) NULL,
    [Audit_SQLUser]                          VARCHAR (100) NULL,
    [REGISTRANT_ID]                          INT           NULL,
    [USER_ID]                                VARCHAR (256) NULL,
    [EDIPI]                                  VARCHAR (50)  NULL,
    [ICN]                                    VARCHAR (50)  NULL,
    [SSN]                                    VARCHAR (20)  NULL,
    [FIRST_NAME]                             VARCHAR (50)  NULL,
    [MIDDLE_NAME]                            VARCHAR (50)  NULL,
    [LAST_NAME]                              VARCHAR (50)  NULL,
    [BIRTH_DATE]                             DATE          NULL,
    [GENDER]                                 VARCHAR (50)  NULL,
    [RACE]                                   VARCHAR (50)  NULL,
    [ETHNICITY]                              VARCHAR (50)  NULL,
    [STD_SERVICE_STATUS_ID]                  INT           NULL,
    [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]    INT           NULL,
    [STD_BRANCH_OF_SERVICE_ID_CURRENT]       INT           NULL,
    [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED] INT           NULL,
    [UIC_CURRENT]                            CHAR (1)      NULL,
    [UIC_WHEN_ENROLLED]                      CHAR (1)      NULL,
    [STD_REGISTRANT_STATUS_ID]               INT           NULL,
    [REGISTRANT_STATUS_LAST_UPDATED_DATE]    DATETIME2 (7) NULL,
    [STD_INSTITUTION_ID]                     INT           NULL,
    [MARITAL_STATUS]                         VARCHAR (50)  NULL,
    [EDUCATION_LEVEL]                        VARCHAR (50)  NULL,
    [STD_SEPARATION_REASON_ID_CURRENT]       INT           NULL,
    [SEPARATION_DATE_CURRENT]                DATE          NULL,
    [STD_SEPARATION_REASON_ID_WHEN_ENROLLED] INT           NULL,
    [SEPARATION_DATE_WHEN_ENROLLED]          DATE          NULL,
    [STD_DISCHARGE_CHARACTER_ID]             INT           NULL,
    [STD_COMPONENT_ID_CURRENT]               INT           NULL,
    [STD_COMPONENT_ID_WHEN_ENROLLED]         INT           NULL,
    [HEALTH_CONCERNS_RESPONSE]               VARCHAR (50)  NULL,
    [REQUEST_SEEN_RESPONSE]                  VARCHAR (50)  NULL,
    [DECEASED_FLAG]                          BIT           NULL,
    [DEATH_DATE]                             DATE          NULL,
    [ELIGIBILITY_STATUS]                     VARCHAR (30)  NULL,
    [ELIGIBILITY]                            VARCHAR (50)  NULL,
    [CONTACT_PREFERENCE]                     VARCHAR (100) NULL,
    [ETL_UPDATED]                            DATETIME2 (7) NULL,
    [ENROLLMENT_STATUS]                      VARCHAR (50)  NULL,
    [ENROLLED_DATE]                          DATE          NULL,
    [CREATEDBY]                              VARCHAR (30)  NULL,
    [UPDATEDBY]                              VARCHAR (30)  NULL,
    [CREATED]                                DATETIME2 (7) NULL,
    [UPDATED]                                DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_H_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_PHONE_H] (
    [Audit_REGISTRANT_PHONE_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                  DATETIME      NOT NULL,
    [Audit_Type]                  VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]       VARCHAR (128) NULL,
    [Audit_SQLUser]               VARCHAR (100) NULL,
    [REGISTRANT_PHONE_ID]         INT           NULL,
    [REGISTRANT_ID]               INT           NULL,
    [TYPE]                        VARCHAR (100) NULL,
    [PHONE_NUMBER]                VARCHAR (50)  NULL,
    [CREATEDBY]                   VARCHAR (30)  NULL,
    [UPDATEDBY]                   VARCHAR (30)  NULL,
    [CREATED]                     DATETIME2 (7) NULL,
    [UPDATED]                     DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_PHONE_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_PHONE_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_RECORD_INFO_H] (
    [Audit_REGISTRANT_RECORD_INFO_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                        DATETIME      NOT NULL,
    [Audit_Type]                        VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]             VARCHAR (128) NULL,
    [Audit_SQLUser]                     VARCHAR (100) NULL,
    [REGISTRANT_ID]                     INT           NULL,
    [EULA_ACCEPTED_DATE]                DATETIME2 (7) NULL,
    [EDIPI_VERIFIED_DATE]               DATETIME2 (7) NULL,
    [EDIPI_MISMATCHED_FLAG]             BIT           NULL,
    [CONTACT_INFO_VERIFIED_DATE]        DATETIME2 (7) NULL,
    [CREATEDBY]                         VARCHAR (30)  NULL,
    [UPDATEDBY]                         VARCHAR (30)  NULL,
    [CREATED]                           DATETIME2 (7) NULL,
    [UPDATED]                           DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_RECORD_INFO_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_RECORD_INFO_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG_H] (
    [Audit_REGISTRANT_REGISTRY_FLAG_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                          DATETIME      NOT NULL,
    [Audit_Type]                          VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]               VARCHAR (128) NULL,
    [Audit_SQLUser]                       VARCHAR (100) NULL,
    [REGISTRANT_REGISTRY_FLAG_ID]         INT           NULL,
    [REGISTRANT_ID]                       INT           NULL,
    [STD_REGISTRY_FLAG_ID]                INT           NULL,
    [CREATEDBY]                           VARCHAR (30)  NULL,
    [UPDATEDBY]                           VARCHAR (30)  NULL,
    [CREATED]                             DATETIME2 (7) NULL,
    [UPDATED]                             DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_REGISTRY_FLAG_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_REGISTRY_FLAG_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[DATA_ACCESS_LOG]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[DATA_ACCESS_LOG] (
    [LOG_ID]      INT           IDENTITY (1, 1) NOT NULL,
    [USER_ID]     VARCHAR (256) NULL,
    [USER_AGENT]  VARCHAR (500) NULL,
    [PAGE_NAME]   VARCHAR (100) NULL,
    [CREATED]     DATETIME      NOT NULL,
    [CREATEDBY]   VARCHAR (30)  NOT NULL,
    [UPDATED]     DATETIME      NOT NULL,
    [UPDATEDBY]   VARCHAR (30)  NOT NULL,
    [ROW_VERSION] TIMESTAMP     NOT NULL,
    CONSTRAINT [PK_DATA_ACCESS_LOG] PRIMARY KEY CLUSTERED ([LOG_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[INTERFACE_CALL_LOG]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[INTERFACE_CALL_LOG] (
    [REGISTRANT_ID]  INT            NULL,
    [INTERFACE_NAME] VARCHAR (50)   NOT NULL,
    [TIME_OF_CALL]   DATETIME2 (0)  NOT NULL,
    [PARAMETERS]     VARCHAR (1000) NULL,
    [RETURN_VALUES]  VARCHAR (1000) NULL,
    [CREATEDBY]      VARCHAR (30)   NOT NULL,
    [UPDATEDBY]      VARCHAR (30)   NOT NULL,
    [CREATED]        DATETIME2 (0)  NOT NULL,
    [UPDATED]        DATETIME2 (0)  NOT NULL
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_FILE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_FILE] (
    [REGISTRANT_FILE_ID] UNIQUEIDENTIFIER           ROWGUIDCOL NOT NULL,
    [FILE_ID]            VARCHAR (256)              NOT NULL,
    [FILE_TYPE]          VARCHAR (256)              NOT NULL,
    [FILE_CONTENT]       VARBINARY (MAX) FILESTREAM NULL,
    [CREATEDBY]          VARCHAR (30)               NOT NULL,
    [UPDATEDBY]          VARCHAR (30)               NOT NULL,
    [CREATED]            DATETIME2 (0)              NOT NULL,
    [UPDATED]            DATETIME2 (0)              NOT NULL,
    [ROW_VERSION]        TIMESTAMP                  NOT NULL,
    CONSTRAINT [PK_REGISTRANT_FILE] PRIMARY KEY CLUSTERED ([REGISTRANT_FILE_ID] ASC) ON [AHOBPR]
) ON [AHOBPR] FILESTREAM_ON [FILESTREAMGroup];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[AUDIT_LOG_TYPE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[AUDIT_LOG_TYPE] (
    [TYPE_ID]     TINYINT       NOT NULL,
    [DESCRIPTION] VARCHAR (100) NOT NULL,
    [CREATED]     DATETIME      NOT NULL,
    [CREATEDBY]   VARCHAR (30)  NOT NULL,
    [UPDATED]     DATETIME      NOT NULL,
    [UPDATEDBY]   VARCHAR (30)  NOT NULL,
    [ROW_VERSION] TIMESTAMP     NOT NULL,
    CONSTRAINT [PK_AUDIT_LOG_TYPE] PRIMARY KEY CLUSTERED ([TYPE_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_COUNTRY]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_COUNTRY] (
    [CODE]        VARCHAR (2)  NOT NULL,
    [DESCRIPTION] VARCHAR (50) NOT NULL,
    CONSTRAINT [PK_STD_COUNTRY] PRIMARY KEY CLUSTERED ([CODE] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_PAY_PLAN_GRADE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_PAY_PLAN_GRADE] (
    [CODE]        VARCHAR (4)  NOT NULL,
    [DESCRIPTION] VARCHAR (50) NOT NULL,
    CONSTRAINT [PK_STD_PAY_PLAN_GRADE] PRIMARY KEY CLUSTERED ([CODE] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[JSON_QUEUE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[JSON_QUEUE] (
    [JSON_QUEUE_ID]         INT            IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_JSON_ID]    INT            NOT NULL,
    [PROCESS_START_DATE]    DATETIME2 (0)  NULL,
    [PROCESS_COMPLETE_DATE] DATETIME2 (0)  NULL,
    [PROCESS_STATUS]        VARCHAR (100)  NULL,
    [PROCESS_ERROR]         VARCHAR (4000) NULL,
    [ROW_VERSION]           ROWVERSION     NOT NULL,
    [CREATEDBY]             VARCHAR (30)   NOT NULL,
    [UPDATEDBY]             VARCHAR (30)   NOT NULL,
    [CREATED]               DATETIME2 (0)  NOT NULL,
    [UPDATED]               DATETIME2 (0)  NOT NULL,
    CONSTRAINT [JSON_QUEUE_PK] PRIMARY KEY CLUSTERED ([JSON_QUEUE_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_DISCHARGE_CHARACTER]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_DISCHARGE_CHARACTER] (
    [STD_DISCHARGE_CHARACTER_ID] INT           IDENTITY (1, 1) NOT NULL,
    [DISCHARGE_CHARACTER_CODE]   VARCHAR (100) NULL,
    [DISCHARGE_CHARACTER]        VARCHAR (100) NOT NULL,
    [CREATEDBY]                  VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                  VARCHAR (30)  NOT NULL,
    [CREATED]                    DATETIME2 (0) NOT NULL,
    [UPDATED]                    DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                TIMESTAMP     NOT NULL,
    CONSTRAINT [STD_DISCHARGE_PK] PRIMARY KEY CLUSTERED ([STD_DISCHARGE_CHARACTER_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_FAMILY]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_SEPARATION_FAMILY] (
    [STD_SEPARATION_FAMILY_ID] INT           IDENTITY (1, 1) NOT NULL,
    [FAMILY_CODE]              CHAR (1)      NULL,
    [FAMILY]                   VARCHAR (100) NOT NULL,
    [CREATEDBY]                VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                VARCHAR (30)  NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    [UPDATED]                  DATETIME2 (0) NOT NULL,
    [ROW_VERSION]              TIMESTAMP     NOT NULL,
    CONSTRAINT [STD_SEPARATION_FAMILY_PK] PRIMARY KEY CLUSTERED ([STD_SEPARATION_FAMILY_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_REASON]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_SEPARATION_REASON] (
    [STD_SEPARATION_REASON_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REASON_CODE]              VARCHAR (10)  NULL,
    [STD_SEPARATION_FAMILY_ID] INT           NULL,
    [REASON]                   VARCHAR (100) NOT NULL,
    [CREATEDBY]                VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                VARCHAR (30)  NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    [UPDATED]                  DATETIME2 (0) NOT NULL,
    [ROW_VERSION]              TIMESTAMP     NOT NULL,
    CONSTRAINT [STD_SEPARATION_REASON_PK] PRIMARY KEY CLUSTERED ([STD_SEPARATION_REASON_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_OCCUPATION]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_SERVICE_OCCUPATION] (
    [STD_SERVICE_OCCUPATION_ID] INT           IDENTITY (1, 1) NOT NULL,
    [SERVICE_OCCUPATION_CODE]   VARCHAR (10)  NOT NULL,
    [SERVICE_TITLE]             VARCHAR (256) NULL,
    [CREATEDBY]                 VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                 VARCHAR (30)  NOT NULL,
    [CREATED]                   DATETIME2 (0) NOT NULL,
    [UPDATED]                   DATETIME2 (0) NOT NULL,
    [ROW_VERSION]               TIMESTAMP     NOT NULL,
    CONSTRAINT [STD_SERVICE_OCCUPATION_PK] PRIMARY KEY CLUSTERED ([STD_SERVICE_OCCUPATION_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_COMPONENT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_COMPONENT] (
    [STD_COMPONENT_ID] INT           IDENTITY (1, 1) NOT NULL,
    [CATEGORY_CODE]    CHAR (1)      NULL,
    [DESCRIPTION]      VARCHAR (100) NOT NULL,
    [CREATEDBY]        VARCHAR (30)  NOT NULL,
    [UPDATEDBY]        VARCHAR (30)  NOT NULL,
    [CREATED]          DATETIME2 (0) NOT NULL,
    [UPDATED]          DATETIME2 (0) NOT NULL,
    [ROW_VERSION]      TIMESTAMP     NOT NULL,
    CONSTRAINT [STD_COMPONENT_PK] PRIMARY KEY CLUSTERED ([STD_COMPONENT_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STAGED_HEALTH_FACTOR]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STAGED_HEALTH_FACTOR] (
    [CDW_VISIT_SID]        BIGINT        NOT NULL,
    [REGISTRANT_ID]        INT           NULL,
    [STD_HEALTH_FACTOR_ID] SMALLINT      NULL,
    [HEALTH_FACTOR_TEXT]   VARCHAR (40)  NULL,
    [COMMENTS]             VARCHAR (255) NULL
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STAGED_PATIENT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STAGED_PATIENT] (
    [PatientSID]                BIGINT       NULL,
    [PatientIEN]                VARCHAR (50) NULL,
    [PatientICN]                VARCHAR (50) NOT NULL,
    [PatientICNChecksum]        VARCHAR (50) NULL,
    [REGISTRANT_ID]             INT          NOT NULL,
    [Sta3N]                     SMALLINT     NULL,
    [PatientSSN]                VARCHAR (50) NULL,
    [Eligibility]               VARCHAR (50) NULL,
    [EligibilityStatus]         VARCHAR (50) NULL,
    [LastServiceSeparationDate] DATE         NULL,
    [GENDER]                    CHAR (1)     NULL,
    [DECEASED]                  CHAR (1)     NULL,
    [DateOfDeath]               DATE         NULL,
    [RaceText]                  VARCHAR (50) NULL,
    [MaritalStatus]             VARCHAR (25) NULL,
    [VistaEditDate]             DATE         NULL,
    [ExtractBatchID]            BIGINT       NULL,
    [EnrollmentStatus]          VARCHAR (50) NULL,
    [PreferredInstitutionCode]  VARCHAR (10) NULL,
    [EnrollmentDate]            DATE         NULL,
    [STD_INSTITUTION_ID]        INT          NULL
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STAGED_PATIENT].[IX_PATIENT_REGISTRANT_ID]...';


GO
CREATE NONCLUSTERED INDEX [IX_PATIENT_REGISTRANT_ID]
    ON [AHOBPR].[STAGED_PATIENT]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[STAGED_VISIT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STAGED_VISIT] (
    [VisitSID]           BIGINT        NOT NULL,
    [REGISTRANT_ID]      INT           NOT NULL,
    [VISTA_EncounterID]  VARCHAR (50)  NULL,
    [PatientICN]         VARCHAR (50)  NOT NULL,
    [PatientSID]         BIGINT        NOT NULL,
    [VISTA_PatientIEN]   VARCHAR (50)  NULL,
    [VISTA_Sta3n]        SMALLINT      NULL,
    [VISIT_DATE_TIME]    DATETIME2 (0) NULL,
    [VISTA_Eligibility]  VARCHAR (50)  NULL,
    [EVALUATION_FLAG]    CHAR (1)      NOT NULL,
    [APPOINTMENT_TYPE]   VARCHAR (50)  NULL,
    [APPOINTMENT_STATUS] VARCHAR (50)  NULL,
    [INSTITUTION_CODE]   VARCHAR (10)  NULL,
    [STOP_CODE]          VARCHAR (50)  NULL,
    [STD_INSTITUTION_ID] INT           NULL
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT] (
    [REGISTRANT_ID]                          INT           IDENTITY (1, 1) NOT NULL,
    [USER_ID]                                VARCHAR (256) NULL,
    [EDIPI]                                  VARCHAR (50)  NOT NULL,
    [ICN]                                    VARCHAR (50)  NULL,
    [SSN]                                    VARCHAR (20)  NOT NULL,
    [FIRST_NAME]                             VARCHAR (50)  NULL,
    [MIDDLE_NAME]                            VARCHAR (50)  NULL,
    [LAST_NAME]                              VARCHAR (50)  NULL,
    [BIRTH_DATE]                             DATE          NULL,
    [GENDER]                                 VARCHAR (50)  NULL,
    [RACE]                                   VARCHAR (50)  NULL,
    [ETHNICITY]                              VARCHAR (50)  NULL,
    [STD_SERVICE_STATUS_ID]                  INT           NULL,
    [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]    INT           NULL,
    [STD_BRANCH_OF_SERVICE_ID_CURRENT]       INT           NULL,
    [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED] INT           NULL,
    [UIC_CURRENT]                            CHAR (6)      NULL,
    [UIC_WHEN_ENROLLED]                      CHAR (6)      NULL,
    [STD_REGISTRANT_STATUS_ID]               INT           NULL,
    [REGISTRANT_STATUS_LAST_UPDATED_DATE]    DATETIME2 (0) NULL,
    [STD_INSTITUTION_ID]                     INT           NULL,
    [MARITAL_STATUS]                         VARCHAR (50)  NULL,
    [EDUCATION_LEVEL]                        VARCHAR (50)  NULL,
    [STD_SEPARATION_REASON_ID_CURRENT]       INT           NULL,
    [SEPARATION_DATE_CURRENT]                DATE          NULL,
    [STD_SEPARATION_REASON_ID_WHEN_ENROLLED] INT           NULL,
    [SEPARATION_DATE_WHEN_ENROLLED]          DATE          NULL,
    [STD_DISCHARGE_CHARACTER_ID]             INT           NULL,
    [STD_COMPONENT_ID_CURRENT]               INT           NULL,
    [STD_COMPONENT_ID_WHEN_ENROLLED]         INT           NULL,
    [HEALTH_CONCERNS_RESPONSE]               VARCHAR (50)  NULL,
    [REQUEST_SEEN_RESPONSE]                  VARCHAR (50)  NULL,
    [DECEASED_FLAG]                          BIT           NOT NULL,
    [DEATH_DATE]                             DATE          NULL,
    [ELIGIBILITY_STATUS]                     VARCHAR (30)  NULL,
    [ELIGIBILITY]                            VARCHAR (50)  NULL,
    [CONTACT_PREFERENCE]                     VARCHAR (100) NULL,
    [ETL_UPDATED]                            DATETIME2 (0) NULL,
    [ENROLLMENT_STATUS]                      VARCHAR (50)  NULL,
    [ENROLLED_DATE]                          DATE          NULL,
    [CREATEDBY]                              VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                              VARCHAR (30)  NOT NULL,
    [CREATED]                                DATETIME2 (0) NOT NULL,
    [UPDATED]                                DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                            ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[IX_REGISTRANT_StdRegistrantStatusId]...';


GO
CREATE NONCLUSTERED INDEX [IX_REGISTRANT_StdRegistrantStatusId]
    ON [AHOBPR].[REGISTRANT]([STD_REGISTRANT_STATUS_ID] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[IX_REGISTRANT_Updated]...';


GO
CREATE NONCLUSTERED INDEX [IX_REGISTRANT_Updated]
    ON [AHOBPR].[REGISTRANT]([UPDATED] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[IX_REGISTRANT_StdInstitutionId]...';


GO
CREATE NONCLUSTERED INDEX [IX_REGISTRANT_StdInstitutionId]
    ON [AHOBPR].[REGISTRANT]([STD_INSTITUTION_ID] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[STD_FORM_QUESTION]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_QUESTION] (
    [STD_FORM_QUESTION_ID]    INT            IDENTITY (1, 1) NOT NULL,
    [STD_FORM_SUB_SECTION_ID] INT            NOT NULL,
    [STD_FORM_SECTION_ID]     INT            NOT NULL,
    [STD_FORM_ID]             INT            NOT NULL,
    [TEXT]                    VARCHAR (4000) NOT NULL,
    [TYPE]                    VARCHAR (100)  NOT NULL,
    [MIN]                     VARCHAR (256)  NOT NULL,
    [MAX]                     VARCHAR (256)  NOT NULL,
    [MAX_CHOICES]             INT            NULL,
    [PARENT_ID]               INT            NULL,
    [FORM_QUESTION_UNIQUE_ID] VARCHAR (100)  NULL,
    [BRP_FORM_QUESTION_ID]    VARCHAR (100)  NULL,
    [BRP_PARENT_QUESTION_ID]  VARCHAR (100)  NULL,
    [MAX_LENGTH]              INT            NULL,
    [MIN_LENGTH]              INT            NULL,
    [POST_REQ_TRIGGER_ONCE]   VARCHAR (100)  NULL,
    [PRE_REQ_OPERATOR]        VARCHAR (100)  NULL,
    [SOURCE_ID]               VARCHAR (100)  NULL,
    [CREATEDBY]               VARCHAR (30)   NOT NULL,
    [UPDATEDBY]               VARCHAR (30)   NOT NULL,
    [CREATED]                 DATETIME2 (0)  NOT NULL,
    [UPDATED]                 DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]             ROWVERSION     NOT NULL,
    [SHORT_TEXT]              VARCHAR (4000) NULL,
    CONSTRAINT [PK_STD_FORM_QUESTION] PRIMARY KEY CLUSTERED ([STD_FORM_QUESTION_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_QUESTION].[IX_STD_FORM_QUESTION_UniqueId]...';


GO
CREATE NONCLUSTERED INDEX [IX_STD_FORM_QUESTION_UniqueId]
    ON [AHOBPR].[STD_FORM_QUESTION]([FORM_QUESTION_UNIQUE_ID] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_PHONE] (
    [REGISTRANT_PHONE_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]       INT           NOT NULL,
    [TYPE]                VARCHAR (100) NULL,
    [PHONE_NUMBER]        VARCHAR (50)  NULL,
    [CREATEDBY]           VARCHAR (30)  NOT NULL,
    [UPDATEDBY]           VARCHAR (30)  NOT NULL,
    [CREATED]             DATETIME2 (0) NOT NULL,
    [UPDATED]             DATETIME2 (0) NOT NULL,
    [ROW_VERSION]         ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_PHONE_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_PHONE_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[IX_RegistrantPhone_RegistrantContactInfoId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantPhone_RegistrantContactInfoId]
    ON [AHOBPR].[REGISTRANT_PHONE]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] (
    [FORM_RESPONSE_QUESTION_ID] INT           IDENTITY (1, 1) NOT NULL,
    [FORM_RESPONSE_ID]          INT           NOT NULL,
    [STD_FORM_QUESTION_ID]      INT           NOT NULL,
    [REGISTRANT_DEPLOYMENT_ID]  INT           NULL,
    [STARTED_DATE]              DATETIME2 (0) NOT NULL,
    [COMPLETED_DATE]            DATETIME2 (0) NULL,
    [CREATEDBY]                 VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                 VARCHAR (30)  NOT NULL,
    [CREATED]                   DATETIME2 (0) NOT NULL,
    [UPDATED]                   DATETIME2 (0) NOT NULL,
    [ROW_VERSION]               ROWVERSION    NOT NULL,
    CONSTRAINT [PK_FORM_RESPONSE_QUESTION] PRIMARY KEY CLUSTERED ([FORM_RESPONSE_QUESTION_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[IX_FORM_RESPONSE_QUESTION_FormResponseId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FORM_RESPONSE_QUESTION_FormResponseId]
    ON [AHOBPR].[FORM_RESPONSE_QUESTION]([FORM_RESPONSE_ID] ASC)
    INCLUDE([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[IX_FORM_RESPONSE_QUESTION_StdFormQuestionId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FORM_RESPONSE_QUESTION_StdFormQuestionId]
    ON [AHOBPR].[FORM_RESPONSE_QUESTION]([FORM_RESPONSE_ID] ASC, [STD_FORM_QUESTION_ID] ASC)
    INCLUDE([FORM_RESPONSE_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[IX_FORM_RESPONSE_QUESTION_DeploymentID]...';


GO
CREATE NONCLUSTERED INDEX [IX_FORM_RESPONSE_QUESTION_DeploymentID]
    ON [AHOBPR].[FORM_RESPONSE_QUESTION]([REGISTRANT_DEPLOYMENT_ID] ASC)
    INCLUDE([FORM_RESPONSE_QUESTION_ID], [FORM_RESPONSE_ID], [STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[STAGED_DOD_DEPLOYMENT_IMPORT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STAGED_DOD_DEPLOYMENT_IMPORT] (
    [DEPLOYMENT_ID]  INT          IDENTITY (1, 1) NOT NULL,
    [EDIPI]          VARCHAR (10) NULL,
    [SVC]            VARCHAR (15) NULL,
    [COMPO]          VARCHAR (10) NULL,
    [LOCATION]       VARCHAR (2)  NULL,
    [DEP_BGN_CDT]    VARCHAR (10) NULL,
    [DEP_END_CDT]    VARCHAR (10) NULL,
    [LOC_BEGIN_DATE] VARCHAR (10) NULL,
    [LOC_END_DATE]   VARCHAR (10) NULL,
    [GRADE]          VARCHAR (4)  NULL,
    [PN_SEX_CD]      VARCHAR (50) NULL,
    [MRTL_STAT_CD]   VARCHAR (50) NULL,
    [EDU_LVL_CD]     VARCHAR (50) NULL,
    [RACE_CD]        VARCHAR (50) NULL,
    [ETH_AFF_CD]     VARCHAR (50) NULL,
    [DTY_DOD_OCC_CD] VARCHAR (50) NULL,
    [Service]        VARCHAR (50) NULL,
    [Component]      VARCHAR (50) NULL
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_JSON]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_JSON] (
    [REGISTRANT_JSON_ID] INT           IDENTITY (1, 1) NOT NULL,
    [OBJECT_ID]          VARCHAR (256) NOT NULL,
    [OBJECT_TYPE]        VARCHAR (100) NOT NULL,
    [JSON_DATA]          VARCHAR (MAX) NOT NULL,
    [CREATEDBY]          VARCHAR (30)  NOT NULL,
    [UPDATEDBY]          VARCHAR (30)  NOT NULL,
    [CREATED]            DATETIME2 (0) NOT NULL,
    [UPDATED]            DATETIME2 (0) NOT NULL,
    [ROW_VERSION]        ROWVERSION    NOT NULL,
    CONSTRAINT [JSON_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_JSON_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
-- Removed until after Migration
--PRINT N'Creating [AHOBPR].[REGISTRANT_JSON].[IX_REGISTRANT_JSON_Object]...';


--GO
--CREATE NONCLUSTERED INDEX [IX_REGISTRANT_JSON_Object]
--    ON [AHOBPR].[REGISTRANT_JSON]([OBJECT_TYPE] ASC, [OBJECT_ID] ASC, [REGISTRANT_JSON_ID] ASC);


--GO
PRINT N'Creating [AHOBPR].[STD_TERM_ANSWER]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_TERM_ANSWER] (
    [STD_TERM_ANSWER_ID] INT           IDENTITY (1, 1) NOT NULL,
    [STD_TERM_ID]        INT           NULL,
    [STD_FORM_ANSWER_ID] INT           NULL,
    [CREATEDBY]          VARCHAR (30)  NOT NULL,
    [UPDATEDBY]          VARCHAR (30)  NOT NULL,
    [CREATED]            DATETIME2 (0) NOT NULL,
    [UPDATED]            DATETIME2 (0) NOT NULL,
    [ROW_VERSION]        TIMESTAMP     NOT NULL,
    CONSTRAINT [PK_STD_TERM_ANSWER] PRIMARY KEY CLUSTERED ([STD_TERM_ANSWER_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_VISIT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_VISIT] (
    [REGISTRANT_VISIT_ID]     INT           IDENTITY (10, 1) NOT NULL,
    [REGISTRANT_ID]           INT           NOT NULL,
    [VISIT_DATE_TIME]         DATETIME2 (0) NULL,
    [STD_INSTITUTION_ID]      INT           NULL,
    [VISTA_EncounterID]       VARCHAR (50)  NULL,
    [VISTA_Sta3n]             SMALLINT      NULL,
    [VISTA_EligibilityStatus] VARCHAR (50)  NULL,
    [EVALUATION_FLAG]         CHAR (1)      NOT NULL,
    [APPOINTMENT_TYPE]        VARCHAR (50)  NULL,
    [STOP_CODE]               VARCHAR (50)  NULL,
    [CREATEDBY]               VARCHAR (30)  NOT NULL,
    [UPDATEDBY]               VARCHAR (30)  NOT NULL,
    [CREATED]                 DATETIME2 (0) NOT NULL,
    [UPDATED]                 DATETIME2 (0) NOT NULL,
    [ROW_VERSION]             TIMESTAMP     NOT NULL,
    CONSTRAINT [PK_REGISTRANT_VISIT] PRIMARY KEY CLUSTERED ([REGISTRANT_VISIT_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[AHOBPR_USER]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[AHOBPR_USER] (
    [USER_ID]          INT          NOT NULL,
    [LAST_LOGIN]       DATETIME     NULL,
    [LAST_VISTA_LOGIN] DATETIME     NULL,
    [ACTIVE_FLAG]      BIT          NOT NULL,
    [CREATED]          DATETIME     NOT NULL,
    [CREATEDBY]        VARCHAR (30) NOT NULL,
    [UPDATED]          DATETIME     NOT NULL,
    [UPDATEDBY]        VARCHAR (30) NOT NULL,
    [ROW_VERSION]      TIMESTAMP    NOT NULL,
    [PENDING_FLAG]     BIT          NOT NULL,
    CONSTRAINT [PK_AHOBPR_USER] PRIMARY KEY CLUSTERED ([USER_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[AUDIT_LOG]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[AUDIT_LOG] (
    [TYPE_ID]       TINYINT        NOT NULL,
    [USER_ID]       INT            NULL,
    [REGISTRANT_ID] INT            NULL,
    [MESSAGE]       VARCHAR (1000) NULL,
    [CREATED]       DATETIME       NOT NULL,
    [CREATEDBY]     VARCHAR (30)   NOT NULL,
    [UPDATED]       DATETIME       NOT NULL,
    [UPDATEDBY]     VARCHAR (30)   NOT NULL,
    [ROW_VERSION]   TIMESTAMP      NOT NULL,
    [LOG_ID]        INT            IDENTITY (1, 1) NOT NULL,
    CONSTRAINT [PK_AUDIT_LOG] PRIMARY KEY CLUSTERED ([LOG_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DOD_DEPLOYMENT_IMPORT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[DOD_DEPLOYMENT_IMPORT] (
    [DEPLOYMENT_ID]         INT          IDENTITY (1, 1) NOT NULL,
    [EDIPI]                 VARCHAR (10) NOT NULL,
    [SERVICE]               VARCHAR (15) NOT NULL,
    [COMPO]                 VARCHAR (10) NOT NULL,
    [LOCATION]              VARCHAR (2)  NOT NULL,
    [DEPLOYMENT_START_DATE] DATE         NOT NULL,
    [DEPLOYMENT_END_DATE]   DATE         NOT NULL,
    [LOCATION_START_DATE]   DATE         NOT NULL,
    [LOCATION_END_DATE]     DATE         NOT NULL,
    [PAY_PLAN_GRADE]        VARCHAR (4)  NOT NULL,
    [IMPORT_DATE]           DATE         NOT NULL
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DOD_DEPLOYMENT_IMPORT].[IX_DOD_DEPLOYMENT_IMPORT_EDIPI]...';


GO
CREATE NONCLUSTERED INDEX [IX_DOD_DEPLOYMENT_IMPORT_EDIPI]
    ON [AHOBPR].[DOD_DEPLOYMENT_IMPORT]([EDIPI] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_TERM_QUESTION]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_TERM_QUESTION] (
    [STD_TERM_QUESTION_ID] INT           IDENTITY (1, 1) NOT NULL,
    [STD_TERM_ID]          INT           NULL,
    [STD_FORM_QUESTION_ID] INT           NULL,
    [CREATEDBY]            VARCHAR (30)  NOT NULL,
    [UPDATEDBY]            VARCHAR (30)  NOT NULL,
    [CREATED]              DATETIME2 (0) NOT NULL,
    [UPDATED]              DATETIME2 (0) NOT NULL,
    [ROW_VERSION]          TIMESTAMP     NOT NULL,
    CONSTRAINT [PK_STD_TERM_QUESTION] PRIMARY KEY CLUSTERED ([STD_TERM_QUESTION_ID] ASC) ON [AHOBPR]
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [dbo].[STD_INSTITUTION].[IX_STD_INSTITUTION_VisnId]...';


GO
CREATE NONCLUSTERED INDEX [IX_STD_INSTITUTION_VisnId]
    ON [dbo].[STD_INSTITUTION]([VISN_ID] ASC)
    INCLUDE([ID], [STATIONNUMBER]);


GO
PRINT N'Creating [AHOBPR].[DF_STD_CONCEPT_CREATED]...';


GO
ALTER TABLE [AHOBPR].[STD_CONCEPT]
    ADD CONSTRAINT [DF_STD_CONCEPT_CREATED] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_CONCEPT_UPDATED]...';


GO
ALTER TABLE [AHOBPR].[STD_CONCEPT]
    ADD CONSTRAINT [DF_STD_CONCEPT_UPDATED] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_TERM_CREATED]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM]
    ADD CONSTRAINT [DF_STD_TERM_CREATED] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_TERM_UPDATED]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM]
    ADD CONSTRAINT [DF_STD_TERM_UPDATED] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_FormResponse_Created]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE]
    ADD CONSTRAINT [DF_FormResponse_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_FormResponse_Updated]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE]
    ADD CONSTRAINT [DF_FormResponse_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormAnswer_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER]
    ADD CONSTRAINT [DF_StdFormAnswer_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormAnswer_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER]
    ADD CONSTRAINT [DF_StdFormAnswer_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormAnswerField_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD]
    ADD CONSTRAINT [DF_StdFormAnswerField_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormAnswerField_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD]
    ADD CONSTRAINT [DF_StdFormAnswerField_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormSection_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SECTION]
    ADD CONSTRAINT [DF_StdFormSection_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormSection_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SECTION]
    ADD CONSTRAINT [DF_StdFormSection_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormSubSection_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION]
    ADD CONSTRAINT [DF_StdFormSubSection_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormSubSection_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION]
    ADD CONSTRAINT [DF_StdFormSubSection_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistrantStatus_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRANT_STATUS]
    ADD CONSTRAINT [DF_StdRegistrantStatus_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistrantStatus_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRANT_STATUS]
    ADD CONSTRAINT [DF_StdRegistrantStatus_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_REGISTRY_FLAG_ACTIVE_FLAG]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_STD_REGISTRY_FLAG_ACTIVE_FLAG] DEFAULT ((1)) FOR [ACTIVE_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_STD_REGISTRY_FLAG_PREDEFINED]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_STD_REGISTRY_FLAG_PREDEFINED] DEFAULT ((0)) FOR [PREDEFINED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistryFlag_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_StdRegistryFlag_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistryFlag_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_StdRegistryFlag_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistryFlagType_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG_TYPE]
    ADD CONSTRAINT [DF_StdRegistryFlagType_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistryFlagType_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG_TYPE]
    ADD CONSTRAINT [DF_StdRegistryFlagType_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_REGISTRY_FLAG_TYPE_ACTIVE_FLAG]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG_TYPE]
    ADD CONSTRAINT [DF_STD_REGISTRY_FLAG_TYPE_ACTIVE_FLAG] DEFAULT ((1)) FOR [ACTIVE_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantRegistryFlag_Created]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_RegistrantRegistryFlag_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantRegistryFlag_Updated]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_RegistrantRegistryFlag_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantEmail_Created]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EMAIL]
    ADD CONSTRAINT [DF_RegistrantEmail_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantEmail_Updated]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EMAIL]
    ADD CONSTRAINT [DF_RegistrantEmail_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantContactInfo_Created]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO]
    ADD CONSTRAINT [DF_RegistrantContactInfo_Created] DEFAULT (getdate()) FOR [CREATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantContactInfo_Updated]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO]
    ADD CONSTRAINT [DF_RegistrantContactInfo_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactorCategory_ActiveFlag]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]
    ADD CONSTRAINT [DF_StdHealthFactorCategory_ActiveFlag] DEFAULT ((1)) FOR [ACTIVE_FLAG];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactorCategory_Created]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]
    ADD CONSTRAINT [DF_StdHealthFactorCategory_Created] DEFAULT (getdate()) FOR [CREATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactorCategory_Updated]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]
    ADD CONSTRAINT [DF_StdHealthFactorCategory_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactor_ActiveFlag]...';


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_StdHealthFactor_ActiveFlag] DEFAULT 1 FOR [ACTIVE_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactor_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_StdHealthFactor_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactor_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_StdHealthFactor_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantHealthFactor_Active]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_RegistrantHealthFactor_Active] DEFAULT ((1)) FOR [ACTIVE_FLAG];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantHealthFactor_Created]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_RegistrantHealthFactor_Created] DEFAULT (getdate()) FOR [CREATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantHealthFactor_Updated]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_RegistrantHealthFactor_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_ErrorLog_Created]...';


GO
ALTER TABLE [AHOBPR].[ERROR_LOG]
    ADD CONSTRAINT [DF_ErrorLog_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_ErrorLog_Updated]...';


GO
ALTER TABLE [AHOBPR].[ERROR_LOG]
    ADD CONSTRAINT [DF_ErrorLog_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdDeploymentLocation_UserAddedFlag]...';


GO
ALTER TABLE [AHOBPR].[STD_DEPLOYMENT_LOCATION]
    ADD CONSTRAINT [DF_StdDeploymentLocation_UserAddedFlag] DEFAULT 0 FOR [USER_ADDED_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_EMAIL_TEMPLATES_Active]...';


GO
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES]
    ADD CONSTRAINT [DF_EMAIL_TEMPLATES_Active] DEFAULT ((0)) FOR [ACTIVE];


GO
PRINT N'Creating [AHOBPR].[DF_EMAIL_TEMPLATES_CREATED]...';


GO
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES]
    ADD CONSTRAINT [DF_EMAIL_TEMPLATES_CREATED] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_EMAIL_TEMPLATES_UPDATED]...';


GO
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES]
    ADD CONSTRAINT [DF_EMAIL_TEMPLATES_UPDATED] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_EMAIL_LOG_CREATED]...';


GO
ALTER TABLE [AHOBPR].[EMAIL_LOG]
    ADD CONSTRAINT [DF_EMAIL_LOG_CREATED] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_EMAIL_LOG_UPDATED]...';


GO
ALTER TABLE [AHOBPR].[EMAIL_LOG]
    ADD CONSTRAINT [DF_EMAIL_LOG_UPDATED] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_EMAIL_LOG_EMAIL_SENT]...';


GO
ALTER TABLE [AHOBPR].[EMAIL_LOG]
    ADD CONSTRAINT [DF_EMAIL_LOG_EMAIL_SENT] DEFAULT (getdate()) FOR [EMAIL_SENT];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantFileId]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_FILE]
    ADD CONSTRAINT [DF_RegistrantFileId] DEFAULT newid() FOR [REGISTRANT_FILE_ID];


GO
PRINT N'Creating [AHOBPR].[DF_Registrant_DeceasedFlag]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT]
    ADD CONSTRAINT [DF_Registrant_DeceasedFlag] DEFAULT ((0)) FOR [DECEASED_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantPhone_Created]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_PHONE]
    ADD CONSTRAINT [DF_RegistrantPhone_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantPhone_Updated]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_PHONE]
    ADD CONSTRAINT [DF_RegistrantPhone_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_TERM_ANS_CREATED]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM_ANSWER]
    ADD CONSTRAINT [DF_STD_TERM_ANS_CREATED] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_TERM_ANS_UPDATED]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM_ANSWER]
    ADD CONSTRAINT [DF_STD_TERM_ANS_UPDATED] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantVisit_EvaluationFlag]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_VISIT]
    ADD CONSTRAINT [DF_RegistrantVisit_EvaluationFlag] DEFAULT 'N' FOR [EVALUATION_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantVisit_Created]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_VISIT]
    ADD CONSTRAINT [DF_RegistrantVisit_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantVisit_Updated]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_VISIT]
    ADD CONSTRAINT [DF_RegistrantVisit_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_TERM_QSTN_CREATED]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM_QUESTION]
    ADD CONSTRAINT [DF_STD_TERM_QSTN_CREATED] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_TERM_QSTN_UPDATED]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM_QUESTION]
    ADD CONSTRAINT [DF_STD_TERM_QSTN_UPDATED] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_STD_CONCEPT]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_STD_CONCEPT] FOREIGN KEY ([STD_CONCEPT_ID]) REFERENCES [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_SYSTEM_STD_TERM]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_SYSTEM_STD_TERM] FOREIGN KEY ([SYSTEM_STD_TERM_ID]) REFERENCES [AHOBPR].[STD_TERM] ([STD_TERM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_ANSWER_FORM_RESPONSE_DETAIL]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_ANSWER_FORM_RESPONSE_DETAIL] FOREIGN KEY ([FORM_RESPONSE_QUESTION_ID]) REFERENCES [AHOBPR].[FORM_RESPONSE_QUESTION] ([FORM_RESPONSE_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_ANSWER_STD_FORM_ANSWER]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_ANSWER_STD_FORM_ANSWER] FOREIGN KEY ([STD_FORM_ANSWER_ID]) REFERENCES [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STATUS_FORM_RESPONSE]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STATUS_FORM_RESPONSE] FOREIGN KEY ([FORM_RESPONSE_ID]) REFERENCES [AHOBPR].[FORM_RESPONSE] ([FORM_RESPONSE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STATUS_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STATUS_STD_FORM_SECTION] FOREIGN KEY ([LAST_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STATUS_STD_FORM_SUB_SECTION]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STATUS_STD_FORM_SUB_SECTION] FOREIGN KEY ([LAST_SUB_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_PROCESS_METRICS_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[PROCESS_METRICS] WITH NOCHECK
    ADD CONSTRAINT [FK_PROCESS_METRICS_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_PROCESS_METRICS_STD_PROCESS_METRICS_TYPE]...';


GO
ALTER TABLE [AHOBPR].[PROCESS_METRICS] WITH NOCHECK
    ADD CONSTRAINT [FK_PROCESS_METRICS_STD_PROCESS_METRICS_TYPE] FOREIGN KEY ([STD_PROCESS_METRICS_TYPE_ID]) REFERENCES [AHOBPR].[STD_PROCESS_METRICS_TYPE] ([STD_PROCESS_METRICS_TYPE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_SECTION] FOREIGN KEY ([STD_FORM_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM_SUB_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_SUB_SECTION] FOREIGN KEY ([STD_FORM_SUB_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_FIELD_STD_FORM_ANSWER]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_FIELD_STD_FORM_ANSWER] FOREIGN KEY ([STD_FORM_ANSWER_ID]) REFERENCES [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_SECTION_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SECTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_SECTION_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_SUB_SECTION_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_SUB_SECTION_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_SUB_SECTION_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_SUB_SECTION_STD_FORM_SECTION] FOREIGN KEY ([STD_FORM_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_StdRegistryFlag_StdRegistryFlagType]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG] WITH NOCHECK
    ADD CONSTRAINT [FK_StdRegistryFlag_StdRegistryFlagType] FOREIGN KEY ([STD_REGISTRY_FLAG_TYPE_ID]) REFERENCES [AHOBPR].[STD_REGISTRY_FLAG_TYPE] ([STD_REGISTRY_FLAG_TYPE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_REGISTRY_FLAG_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_REGISTRY_FLAG_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_REGISTRY_FLAG_STD_REGISTRY_FLAG]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_REGISTRY_FLAG_STD_REGISTRY_FLAG] FOREIGN KEY ([STD_REGISTRY_FLAG_ID]) REFERENCES [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_EMAIL_REGISTRANT_CONTACT_INFO]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EMAIL] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_EMAIL_REGISTRANT_CONTACT_INFO] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT_CONTACT_INFO] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_DEPLOYMENT_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_DEPLOYMENT_OCCUPATION]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_OCCUPATION] FOREIGN KEY ([STD_SERVICE_OCCUPATION_ID]) REFERENCES [AHOBPR].[STD_SERVICE_OCCUPATION] ([STD_SERVICE_OCCUPATION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantDeployHx_StdBranchOfService]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantDeployHx_StdBranchOfService] FOREIGN KEY ([STD_BRANCH_OF_SERVICE_ID]) REFERENCES [AHOBPR].[STD_BRANCH_OF_SERVICE] ([STD_BRANCH_OF_SERVICE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_DEPLOYMENT_STD_COMPONENT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_STD_COMPONENT] FOREIGN KEY ([STD_COMPONENT_ID]) REFERENCES [AHOBPR].[STD_COMPONENT] ([STD_COMPONENT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantContactInfo_Registrant]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantContactInfo_Registrant] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_ADDRESS_REGISTRANT_CONTACT_INFO]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_ADDRESS] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_ADDRESS_REGISTRANT_CONTACT_INFO] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT_CONTACT_INFO] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_StdHealthFactor_StdHealthFactorCategory]...';


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR] WITH NOCHECK
    ADD CONSTRAINT [FK_StdHealthFactor_StdHealthFactorCategory] FOREIGN KEY ([STD_HEALTH_FACTOR_CATEGORY_ID]) REFERENCES [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] ([STD_HEALTH_FACTOR_CATEGORY_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantHealthFactor_RegistrantVisit]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantHealthFactor_RegistrantVisit] FOREIGN KEY ([REGISTRANT_VISIT_ID]) REFERENCES [AHOBPR].[REGISTRANT_VISIT] ([REGISTRANT_VISIT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantHealthFactor_StdHealthFactor]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantHealthFactor_StdHealthFactor] FOREIGN KEY ([STD_HEALTH_FACTOR_ID]) REFERENCES [AHOBPR].[STD_HEALTH_FACTOR] ([STD_HEALTH_FACTOR_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_SERVICE_EPISODE_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_SERVICE_EPISODE_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_ServiceEpisode_StdBranchOfService]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] WITH NOCHECK
    ADD CONSTRAINT [FK_ServiceEpisode_StdBranchOfService] FOREIGN KEY ([STD_BRANCH_OF_SERVICE_ID]) REFERENCES [AHOBPR].[STD_BRANCH_OF_SERVICE] ([STD_BRANCH_OF_SERVICE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_INFO_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_RECORD_INFO] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_INFO_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_EMAIL_LOG_EMAIL_TEMPLATES]...';


GO
ALTER TABLE [AHOBPR].[EMAIL_LOG] WITH NOCHECK
    ADD CONSTRAINT [FK_EMAIL_LOG_EMAIL_TEMPLATES] FOREIGN KEY ([TEMPLATE_ID]) REFERENCES [AHOBPR].[EMAIL_TEMPLATES] ([TEMPLATE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_EMAIL_LOG_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[EMAIL_LOG] WITH NOCHECK
    ADD CONSTRAINT [FK_EMAIL_LOG_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_SEPARATION_REASON_STD_FAMILY]...';


GO
ALTER TABLE [AHOBPR].[STD_SEPARATION_REASON] WITH NOCHECK
    ADD CONSTRAINT [FK_SEPARATION_REASON_STD_FAMILY] FOREIGN KEY ([STD_SEPARATION_FAMILY_ID]) REFERENCES [AHOBPR].[STD_SEPARATION_FAMILY] ([STD_SEPARATION_FAMILY_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_INSTITUTION]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_INSTITUTION] FOREIGN KEY ([STD_INSTITUTION_ID]) REFERENCES [dbo].[STD_INSTITUTION] ([ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_REGISTRANT_STATUS]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_REGISTRANT_STATUS] FOREIGN KEY ([STD_REGISTRANT_STATUS_ID]) REFERENCES [AHOBPR].[STD_REGISTRANT_STATUS] ([STD_REGISTRANT_STATUS_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_SERVICE_STATUS]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_SERVICE_STATUS] FOREIGN KEY ([STD_SERVICE_STATUS_ID]) REFERENCES [AHOBPR].[STD_SERVICE_STATUS] ([STD_SERVICE_STATUS_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_SERVICE_STATUS2]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_SERVICE_STATUS2] FOREIGN KEY ([STD_SERVICE_STATUS_ID_WHEN_ENROLLED]) REFERENCES [AHOBPR].[STD_SERVICE_STATUS] ([STD_SERVICE_STATUS_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_BRANCH_OF_SERVICE]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_BRANCH_OF_SERVICE] FOREIGN KEY ([STD_BRANCH_OF_SERVICE_ID_CURRENT]) REFERENCES [AHOBPR].[STD_BRANCH_OF_SERVICE] ([STD_BRANCH_OF_SERVICE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_BRANCH_OF_SERVICE2]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_BRANCH_OF_SERVICE2] FOREIGN KEY ([STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]) REFERENCES [AHOBPR].[STD_BRANCH_OF_SERVICE] ([STD_BRANCH_OF_SERVICE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_COMPONENT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_COMPONENT] FOREIGN KEY ([STD_COMPONENT_ID_CURRENT]) REFERENCES [AHOBPR].[STD_COMPONENT] ([STD_COMPONENT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_COMPONENT2]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_COMPONENT2] FOREIGN KEY ([STD_COMPONENT_ID_WHEN_ENROLLED]) REFERENCES [AHOBPR].[STD_COMPONENT] ([STD_COMPONENT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_SEPARATION_REASON]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_SEPARATION_REASON] FOREIGN KEY ([STD_SEPARATION_REASON_ID_CURRENT]) REFERENCES [AHOBPR].[STD_SEPARATION_REASON] ([STD_SEPARATION_REASON_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_SEPARATION_REASON2]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_SEPARATION_REASON2] FOREIGN KEY ([STD_SEPARATION_REASON_ID_WHEN_ENROLLED]) REFERENCES [AHOBPR].[STD_SEPARATION_REASON] ([STD_SEPARATION_REASON_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_[STD_DISCHARGE_CHARACTER]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_[STD_DISCHARGE_CHARACTER] FOREIGN KEY ([STD_DISCHARGE_CHARACTER_ID]) REFERENCES [AHOBPR].[STD_DISCHARGE_CHARACTER] ([STD_DISCHARGE_CHARACTER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM_SECTION] FOREIGN KEY ([STD_FORM_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_FORM_SUB_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM_SUB_SECTION] FOREIGN KEY ([STD_FORM_SUB_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_PHONE_REGISTRANT_CONTACT_INFO]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_PHONE] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_PHONE_REGISTRANT_CONTACT_INFO] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT_CONTACT_INFO] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FormResponseQuestion_FORM_RESPONSE]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_FormResponseQuestion_FORM_RESPONSE] FOREIGN KEY ([FORM_RESPONSE_ID]) REFERENCES [AHOBPR].[FORM_RESPONSE] ([FORM_RESPONSE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FormResponseQuestion_REGISTRANT_DEPLOYMENT_HISTORY]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_FormResponseQuestion_REGISTRANT_DEPLOYMENT_HISTORY] FOREIGN KEY ([REGISTRANT_DEPLOYMENT_ID]) REFERENCES [AHOBPR].[REGISTRANT_DEPLOYMENT] ([REGISTRANT_DEPLOYMENT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FormResponseQuestion_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_FormResponseQuestion_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_ANSWER_STD_ANSWER]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_ANSWER_STD_ANSWER] FOREIGN KEY ([STD_FORM_ANSWER_ID]) REFERENCES [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_ANSWER_STD_TERM]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_ANSWER_STD_TERM] FOREIGN KEY ([STD_TERM_ID]) REFERENCES [AHOBPR].[STD_TERM] ([STD_TERM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantVisit_DboStdInstituion]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_VISIT] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantVisit_DboStdInstituion] FOREIGN KEY ([STD_INSTITUTION_ID]) REFERENCES [dbo].[STD_INSTITUTION] ([ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantVisit_Registrant]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_VISIT] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantVisit_Registrant] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_USER_USERS]...';


GO
ALTER TABLE [AHOBPR].[AHOBPR_USER] WITH NOCHECK
    ADD CONSTRAINT [FK_USER_USERS] FOREIGN KEY ([USER_ID]) REFERENCES [dbo].[USERS] ([USER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_AUDIT_LOG_AUDIT_LOG_TYPE]...';


GO
ALTER TABLE [AHOBPR].[AUDIT_LOG] WITH NOCHECK
    ADD CONSTRAINT [FK_AUDIT_LOG_AUDIT_LOG_TYPE] FOREIGN KEY ([TYPE_ID]) REFERENCES [AHOBPR].[AUDIT_LOG_TYPE] ([TYPE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_DOD_DEPLOYMENT_IMPORT_STD_COUNTRY]...';


GO
ALTER TABLE [AHOBPR].[DOD_DEPLOYMENT_IMPORT] WITH NOCHECK
    ADD CONSTRAINT [FK_DOD_DEPLOYMENT_IMPORT_STD_COUNTRY] FOREIGN KEY ([LOCATION]) REFERENCES [AHOBPR].[STD_COUNTRY] ([CODE]);


GO
PRINT N'Creating [AHOBPR].[FK_DOD_DEPLOYMENT_IMPORT_STD_PAY_PLAN_GRADE]...';


GO
ALTER TABLE [AHOBPR].[DOD_DEPLOYMENT_IMPORT] WITH NOCHECK
    ADD CONSTRAINT [FK_DOD_DEPLOYMENT_IMPORT_STD_PAY_PLAN_GRADE] FOREIGN KEY ([PAY_PLAN_GRADE]) REFERENCES [AHOBPR].[STD_PAY_PLAN_GRADE] ([CODE]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_QUESTION_STD_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_QUESTION_STD_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_QUESTION_STD_TERM]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_QUESTION_STD_TERM] FOREIGN KEY ([STD_TERM_ID]) REFERENCES [AHOBPR].[STD_TERM] ([STD_TERM_ID]);


GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_H]...';


GO
Create trigger [AHOBPR].[TRG_FORM_RESPONSE_H] on [AHOBPR].[FORM_RESPONSE]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[FORM_RESPONSE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_ID]
, [REGISTRANT_ID]
, [STD_FORM_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FORM_RESPONSE_ID]
, [REGISTRANT_ID]
, [STD_FORM_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_FORM_RESPONSE_DEL_H]
on  [AHOBPR].[FORM_RESPONSE] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[FORM_RESPONSE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_ID]
, [REGISTRANT_ID]
, [STD_FORM_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FORM_RESPONSE_ID]
, [REGISTRANT_ID]
, [STD_FORM_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_ANSWER_H]...';


GO
Create trigger [AHOBPR].[TRG_FORM_RESPONSE_ANSWER_H] on [AHOBPR].[FORM_RESPONSE_ANSWER]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[FORM_RESPONSE_ANSWER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_ANSWER_ID]
, [FORM_RESPONSE_QUESTION_ID]
, [STD_FORM_ANSWER_ID]
, [ANSWER_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FORM_RESPONSE_ANSWER_ID]
, [FORM_RESPONSE_QUESTION_ID]
, [STD_FORM_ANSWER_ID]
, [ANSWER_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_ANSWER_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_FORM_RESPONSE_ANSWER_DEL_H]
on  [AHOBPR].[FORM_RESPONSE_ANSWER] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[FORM_RESPONSE_ANSWER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_ANSWER_ID]
, [FORM_RESPONSE_QUESTION_ID]
, [STD_FORM_ANSWER_ID]
, [ANSWER_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FORM_RESPONSE_ANSWER_ID]
, [FORM_RESPONSE_QUESTION_ID]
, [STD_FORM_ANSWER_ID]
, [ANSWER_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_STATUS_H]...';


GO
Create trigger [AHOBPR].[TRG_FORM_RESPONSE_STATUS_H] on [AHOBPR].[FORM_RESPONSE_STATUS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[FORM_RESPONSE_STATUS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_STATUS_ID]
, [FORM_RESPONSE_ID]
, [LAST_SECTION_ID]
, [LAST_SUB_SECTION_ID]
, [QUESTIONNAIRE_STARTED_DATE]
, [QUESTIONNAIRE_COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FORM_RESPONSE_STATUS_ID]
, [FORM_RESPONSE_ID]
, [LAST_SECTION_ID]
, [LAST_SUB_SECTION_ID]
, [QUESTIONNAIRE_STARTED_DATE]
, [QUESTIONNAIRE_COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_STATUS_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_FORM_RESPONSE_STATUS_DEL_H]
on  [AHOBPR].[FORM_RESPONSE_STATUS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[FORM_RESPONSE_STATUS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_STATUS_ID]
, [FORM_RESPONSE_ID]
, [LAST_SECTION_ID]
, [LAST_SUB_SECTION_ID]
, [QUESTIONNAIRE_STARTED_DATE]
, [QUESTIONNAIRE_COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FORM_RESPONSE_STATUS_ID]
, [FORM_RESPONSE_ID]
, [LAST_SECTION_ID]
, [LAST_SUB_SECTION_ID]
, [QUESTIONNAIRE_STARTED_DATE]
, [QUESTIONNAIRE_COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_REGISTRY_FLAG_H]...';


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_REGISTRY_FLAG_H] on [AHOBPR].[REGISTRANT_REGISTRY_FLAG]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_REGISTRY_FLAG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_REGISTRY_FLAG_ID]
, [REGISTRANT_ID]
, [STD_REGISTRY_FLAG_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_REGISTRY_FLAG_ID]
, [REGISTRANT_ID]
, [STD_REGISTRY_FLAG_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_REGISTRY_FLAG_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_REGISTRY_FLAG_DEL_H]
on  [AHOBPR].[REGISTRANT_REGISTRY_FLAG] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_REGISTRY_FLAG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_REGISTRY_FLAG_ID]
, [REGISTRANT_ID]
, [STD_REGISTRY_FLAG_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_REGISTRY_FLAG_ID]
, [REGISTRANT_ID]
, [STD_REGISTRY_FLAG_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_EMAIL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_EMAIL_H] on [AHOBPR].[REGISTRANT_EMAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_EMAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_EMAIL_ID]
, [REGISTRANT_ID]
, [TYPE]
, [EMAIL]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_EMAIL_ID]
, [REGISTRANT_ID]
, [TYPE]
, [EMAIL]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_EMAIL_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_EMAIL_DEL_H]
on  [AHOBPR].[REGISTRANT_EMAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_EMAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_EMAIL_ID]
, [REGISTRANT_ID]
, [TYPE]
, [EMAIL]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_EMAIL_ID]
, [REGISTRANT_ID]
, [TYPE]
, [EMAIL]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_CONTACT_INFO_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_CONTACT_INFO_H] on [AHOBPR].[REGISTRANT_CONTACT_INFO]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_CONTACT_INFO_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [FIRST_NAME_CONFIRMED]
, [MIDDLE_NAME_CONFIRMED]
, [LAST_NAME_CONFIRMED]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ID]
, [FIRST_NAME_CONFIRMED]
, [MIDDLE_NAME_CONFIRMED]
, [LAST_NAME_CONFIRMED]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_CONTACT_INFO_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_CONTACT_INFO_DEL_H]
on  [AHOBPR].[REGISTRANT_CONTACT_INFO] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_CONTACT_INFO_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [FIRST_NAME_CONFIRMED]
, [MIDDLE_NAME_CONFIRMED]
, [LAST_NAME_CONFIRMED]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_ID]
, [FIRST_NAME_CONFIRMED]
, [MIDDLE_NAME_CONFIRMED]
, [LAST_NAME_CONFIRMED]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_ADDRESS_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_ADDRESS_H] on [AHOBPR].[REGISTRANT_ADDRESS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_ADDRESS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ADDRESS_ID]
, [REGISTRANT_ID]
, [TYPE]
, [STREET1]
, [STREET2]
, [CITY]
, [STATE]
, [ZIP]
, [COUNTRY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ADDRESS_ID]
, [REGISTRANT_ID]
, [TYPE]
, [STREET1]
, [STREET2]
, [CITY]
, [STATE]
, [ZIP]
, [COUNTRY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_ADDRESS_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_ADDRESS_DEL_H]
on  [AHOBPR].[REGISTRANT_ADDRESS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_ADDRESS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ADDRESS_ID]
, [REGISTRANT_ID]
, [TYPE]
, [STREET1]
, [STREET2]
, [CITY]
, [STATE]
, [ZIP]
, [COUNTRY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_ADDRESS_ID]
, [REGISTRANT_ID]
, [TYPE]
, [STREET1]
, [STREET2]
, [CITY]
, [STATE]
, [ZIP]
, [COUNTRY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_RECORD_INFO_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_RECORD_INFO_H] on [AHOBPR].[REGISTRANT_RECORD_INFO]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_RECORD_INFO_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [EULA_ACCEPTED_DATE]
, [EDIPI_VERIFIED_DATE]
, [EDIPI_MISMATCHED_FLAG]
, [CONTACT_INFO_VERIFIED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ID]
, [EULA_ACCEPTED_DATE]
, [EDIPI_VERIFIED_DATE]
, [EDIPI_MISMATCHED_FLAG]
, [CONTACT_INFO_VERIFIED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_RECORD_INFO_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_RECORD_INFO_DEL_H]
on  [AHOBPR].[REGISTRANT_RECORD_INFO] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_RECORD_INFO_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [EULA_ACCEPTED_DATE]
, [EDIPI_VERIFIED_DATE]
, [EDIPI_MISMATCHED_FLAG]
, [CONTACT_INFO_VERIFIED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_ID]
, [EULA_ACCEPTED_DATE]
, [EDIPI_VERIFIED_DATE]
, [EDIPI_MISMATCHED_FLAG]
, [CONTACT_INFO_VERIFIED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_Ins_Upd]...';


GO

CREATE TRIGGER [AHOBPR].[TRG_REGISTRANT_Ins_Upd]
    ON [AHOBPR].[REGISTRANT]
    FOR INSERT, UPDATE
    AS
    BEGIN
        SET NoCount ON
        DECLARE @MetricsTypeId int = (SELECT STD_PROCESS_METRICS_TYPE_ID FROM STD_PROCESS_METRICS_TYPE WHERE PROCESS_METRICS  = 'Registrant Status Change');

        --set the [REGISTRANT_STATUS_LAST_UPDATED_DATE] field if a status change is detected
        UPDATE  [AHOBPR].[REGISTRANT]
          SET   [REGISTRANT_STATUS_LAST_UPDATED_DATE] = UPDATED
          WHERE NOT EXISTS (
                              SELECT  *
                              FROM    deleted
                              INNER
                              JOIN    inserted
                                ON    inserted.REGISTRANT_ID = deleted.REGISTRANT_ID
                              WHERE   
                                      inserted.REGISTRANT_ID            = deleted.REGISTRANT_ID
                                  AND inserted.STD_REGISTRANT_STATUS_ID = deleted.STD_REGISTRANT_STATUS_ID
                                  AND [REGISTRANT].REGISTRANT_ID = inserted.REGISTRANT_ID
                            )
                AND [REGISTRANT_STATUS_LAST_UPDATED_DATE] != UPDATED;

        --Insert a 'Registrant Status Change' events into AHOBPR.PROCESS_METRICS if changes are detected
        INSERT   
          INTO    AHOBPR.PROCESS_METRICS 
                  (
                    [REGISTRANT_ID],
                    [STD_PROCESS_METRICS_TYPE_ID],
                    [PROCESS_METRICS_VALUE],
                    [CREATEDBY],
                    [UPDATEDBY],
                    [CREATED],
                    [UPDATED]
                  )
          SELECT  [REGISTRANT_ID],
                  @MetricsTypeId,
                  s.REGISTRANT_STATUS,
                  inserted.[UPDATEDBY],
                  inserted.[UPDATEDBY],
                  inserted.[UPDATED],
                  inserted.[UPDATED]
          FROM
                  inserted
          JOIN    AHOBPR.STD_REGISTRANT_STATUS AS s
            ON    s.STD_REGISTRANT_STATUS_ID = inserted.STD_REGISTRANT_STATUS_ID
          WHERE   NOT EXISTS (
                              SELECT  *
                              FROM    deleted
                              WHERE   inserted.REGISTRANT_ID            = deleted.REGISTRANT_ID
                                  AND inserted.STD_REGISTRANT_STATUS_ID = deleted.STD_REGISTRANT_STATUS_ID
                            );
        
    END
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_H]...';


GO

Create trigger [AHOBPR].[TRG_REGISTRANT_H] on [AHOBPR].[REGISTRANT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [RACE]
, [ETHNICITY]
, [STD_SERVICE_STATUS_ID]
, [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS]
, [EDUCATION_LEVEL]
, [STD_SEPARATION_REASON_ID_CURRENT]
, [SEPARATION_DATE_CURRENT]
, [STD_SEPARATION_REASON_ID_WHEN_ENROLLED]
, [SEPARATION_DATE_WHEN_ENROLLED]
, [STD_DISCHARGE_CHARACTER_ID]
, [STD_COMPONENT_ID_CURRENT]
, [STD_COMPONENT_ID_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [ELIGIBILITY_STATUS]
, [ELIGIBILITY]
, [CONTACT_PREFERENCE]
, [ETL_UPDATED]
, [ENROLLMENT_STATUS]
, [ENROLLED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [RACE]
, [ETHNICITY]
, [STD_SERVICE_STATUS_ID]
, [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS]
, [EDUCATION_LEVEL]
, [STD_SEPARATION_REASON_ID_CURRENT]
, [SEPARATION_DATE_CURRENT]
, [STD_SEPARATION_REASON_ID_WHEN_ENROLLED]
, [SEPARATION_DATE_WHEN_ENROLLED]
, [STD_DISCHARGE_CHARACTER_ID]
, [STD_COMPONENT_ID_CURRENT]
, [STD_COMPONENT_ID_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [ELIGIBILITY_STATUS]
, [ELIGIBILITY]
, [CONTACT_PREFERENCE]
, [ETL_UPDATED]
, [ENROLLMENT_STATUS]
, [ENROLLED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_DEL_H]...';


GO


CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_DEL_H]
ON  [AHOBPR].[REGISTRANT] After DELETE
AS
BEGIN 
DECLARE @pos INT, @VCHAR VARCHAR(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [RACE]
, [ETHNICITY]
, [STD_SERVICE_STATUS_ID]
, [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS]
, [EDUCATION_LEVEL]
, [STD_SEPARATION_REASON_ID_CURRENT]
, [SEPARATION_DATE_CURRENT]
, [STD_SEPARATION_REASON_ID_WHEN_ENROLLED]
, [SEPARATION_DATE_WHEN_ENROLLED]
, [STD_DISCHARGE_CHARACTER_ID]
, [STD_COMPONENT_ID_CURRENT]
, [STD_COMPONENT_ID_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [ELIGIBILITY_STATUS]
, [ELIGIBILITY]
, [CONTACT_PREFERENCE]
, [ETL_UPDATED]
, [ENROLLMENT_STATUS]
, [ENROLLED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [RACE]
, [ETHNICITY]
, [STD_SERVICE_STATUS_ID]
, [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS]
, [EDUCATION_LEVEL]
, [STD_SEPARATION_REASON_ID_CURRENT]
, [SEPARATION_DATE_CURRENT]
, [STD_SEPARATION_REASON_ID_WHEN_ENROLLED]
, [SEPARATION_DATE_WHEN_ENROLLED]
, [STD_DISCHARGE_CHARACTER_ID]
, [STD_COMPONENT_ID_CURRENT]
, [STD_COMPONENT_ID_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [ELIGIBILITY_STATUS]
, [ELIGIBILITY]
, [CONTACT_PREFERENCE]
, [ETL_UPDATED]
, [ENROLLMENT_STATUS]
, [ENROLLED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_PHONE_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_PHONE_H] on [AHOBPR].[REGISTRANT_PHONE]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_PHONE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_PHONE_ID]
, [REGISTRANT_ID]
, [TYPE]
, [PHONE_NUMBER]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_PHONE_ID]
, [REGISTRANT_ID]
, [TYPE]
, [PHONE_NUMBER]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_PHONE_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_PHONE_DEL_H]
on  [AHOBPR].[REGISTRANT_PHONE] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_PHONE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_PHONE_ID]
, [REGISTRANT_ID]
, [TYPE]
, [PHONE_NUMBER]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_PHONE_ID]
, [REGISTRANT_ID]
, [TYPE]
, [PHONE_NUMBER]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_QUESTION_H]...';


GO
Create trigger [AHOBPR].[TRG_FORM_RESPONSE_QUESTION_H] on [AHOBPR].[FORM_RESPONSE_QUESTION]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[FORM_RESPONSE_QUESTION_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_QUESTION_ID]
, [FORM_RESPONSE_ID]
, [STD_FORM_QUESTION_ID]
, [REGISTRANT_DEPLOYMENT_ID]
, [STARTED_DATE]
, [COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FORM_RESPONSE_QUESTION_ID]
, [FORM_RESPONSE_ID]
, [STD_FORM_QUESTION_ID]
, [REGISTRANT_DEPLOYMENT_ID]
, [STARTED_DATE]
, [COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_QUESTION_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_FORM_RESPONSE_QUESTION_DEL_H]
on  [AHOBPR].[FORM_RESPONSE_QUESTION] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[FORM_RESPONSE_QUESTION_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_QUESTION_ID]
, [FORM_RESPONSE_ID]
, [STD_FORM_QUESTION_ID]
, [REGISTRANT_DEPLOYMENT_ID]
, [STARTED_DATE]
, [COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FORM_RESPONSE_QUESTION_ID]
, [FORM_RESPONSE_ID]
, [STD_FORM_QUESTION_ID]
, [REGISTRANT_DEPLOYMENT_ID]
, [STARTED_DATE]
, [COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_JSON_INSERT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER [AHOBPR].[TRG_REGISTRANT_JSON_INSERT]
    ON [AHOBPR].[REGISTRANT_JSON]
    FOR INSERT
    AS 
    BEGIN
        SET NoCount ON
        DECLARE @registrantJsonId INT, @objectId VARCHAR(256), @objectType VARCHAR(100),  @CreatedBy VARCHAR(100);
        
        SELECT @registrantJsonId = REGISTRANT_JSON_ID, 
               @objectId   = [OBJECT_ID], 
               @objectType = [OBJECT_TYPE],
               @CreatedBy  = [CREATEDBY] 
          FROM INSERTED;
        
        -- Delete previous records for the same object ID and object type
        DELETE FROM [AHOBPR].[REGISTRANT_JSON]
        WHERE REGISTRANT_JSON_ID != @registrantJsonId
            AND [OBJECT_ID] = @objectId
            AND [OBJECT_TYPE] = @objectType;

        -- Insert to JSON_QUEUE table
        INSERT INTO [AHOBPR].[JSON_QUEUE] ([REGISTRANT_JSON_ID], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY])
        VALUES (@registrantJsonId, GETDATE(),GETDATE(),@CreatedBy,@CreatedBy);     
    END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO

PRINT N'Disable  [AHOBPR].[TRG_REGISTRANT_JSON_INSERT]...';
GO
DISABLE TRIGGER [AHOBPR].[TRG_REGISTRANT_JSON_INSERT]
    ON [AHOBPR].[REGISTRANT_JSON];
GO    
PRINT N'Creating [AHOBPR].[GetAppPageId]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO

CREATE FUNCTION [AHOBPR].[GetAppPageId](
   @code varchar(1000)
)
RETURNS INT
AS
BEGIN
	declare @result INT = 0;
	SET @result = (SELECT ID FROM STD_APPPAGE WHERE Code = @code);
	return @result;
END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[GetStateCodeByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE FUNCTION [AHOBPR].[GetStateCodeByID](
   @stateId varchar(1000)
)
RETURNS varchar(2000)
AS
BEGIN
	declare @result varchar(2000) = '';
	IF ISNULL(@stateId, '') = ''
		BEGIN
			SET @result = 'AK,AR,AZ,CA,CO,CT,DE,FL,GA,HI,IA,ID,IL,IN,KS,KY,LA,MA,MD,ME,MI,MN,MO,MS,MT,NC,ND,NE,NH,NJ,NM,NV,NY,OH,OK,OR,PA,RI,SC,SD,TN,TX,UT,VA,VT,WA,WI,WV,WY';
		END
	ELSE
	  BEGIN
			DECLARE @state varchar(100);

			DECLARE curState CURSOR 
			  FOR
				SELECT POSTALNAME
				FROM dbo.STD_STATE
				WHERE ID IN (SELECT * FROM fncSplit(@stateId, ','));

			OPEN curState;
			FETCH NEXT FROM curState INTO @state;
			WHILE @@FETCH_STATUS = 0  -- Not End of file
			  BEGIN
				  if  @result != ''
					  SET @result = @result + ','
  				
				  SET @result = @result + @state;
  				
				  FETCH NEXT FROM curState INTO @state;			
			  END		
			CLOSE curState;   
			DEALLOCATE curState;    
	  END 
	return @result;
END;
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [dbo].[AddMaxTime]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 2015.01.09
-- Description:	Add 23:59:59 to a date criteria field to ensure an Ending date parameter will include all rows for the last day.
-- =============================================
CREATE FUNCTION [dbo].[AddMaxTime]
(
     @dateIn   DATETIME2(0)
)
RETURNS DATETIME2(0)
AS 
BEGIN    
 
    return CONVERT(DATETIME2(0), CONVERT(varchar(10),@dateIn, 120)+' 23:59:59', 120);
END

--  select dbo.AddMaxTime(GETDATE());
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [dbo].[CleanDate]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 2015.01.09
-- Description:	Convert a VARCHAR date parameter to a vaid date or return NULL if not valid
-- =============================================
CREATE FUNCTION [dbo].[CleanDate]
(
     @inputText   VARCHAR(100) = NULL
)
RETURNS DATETIME2(0)
AS 
BEGIN    

  DECLARE @returnDate DATETIME2(0) = NULL;
  
  SET @inputText = ISNULL(@inputText,'');
 
  IF ISDATE(@inputText) = 1 
    IF PATINDEX ( '%/%' , @inputText ) > 1
      SET @returnDate = CONVERT(DATETIME2(0),@inputText, 101);
    ELSE
      SET @returnDate = CONVERT(DATETIME2(0),@inputText, 120);
  
    return @returnDate;
END

--  select dbo.CleanDate('09/11/2014');
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [dbo].[MixedCase]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 2015.01.09
-- Description:	Return VARCHAR field as upper case for first Character and lower for the remaining characters
-- =============================================
CREATE FUNCTION [dbo].[MixedCase]
(
     @inputText   VARCHAR(100) = NULL
)
RETURNS VARCHAR(100)
AS 
BEGIN    

  DECLARE @returnText VARCHAR(100) = ''
  
  SET @inputText = ISNULL(@inputText,'');
 
  IF LEN(@inputText) = 1   
     SET @returnText = UPPER(@inputText)
  ELSE
  IF LEN(@inputText) > 1   
     SET @returnText = RTRIM(UPPER(SUBSTRING(@inputText,1,1)) + LOWER(SUBSTRING(@inputText,2,99)));
  
    return @returnText;
END

--  select dbo.MixedCase('bruce');
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[VIEW_FORM]...';


GO


CREATE VIEW [AHOBPR].[VIEW_FORM] AS 
SELECT AHOBPR.STD_FORM.STD_FORM_ID, AHOBPR.STD_FORM.NAME, AHOBPR.STD_FORM.VERSION, AHOBPR.STD_FORM.TITLE, 
	AHOBPR.STD_FORM_SECTION.STD_FORM_SECTION_ID, AHOBPR.STD_FORM_SECTION.TITLE AS SECTION, 
	AHOBPR.STD_FORM_SUB_SECTION.STD_FORM_SUB_SECTION_ID, AHOBPR.STD_FORM_SUB_SECTION.title AS SUBSECTION_TITLE, 
	AHOBPR.STD_FORM_SUB_SECTION.introduction AS SUBSECTION_INTRODUCTION, 
	AHOBPR.STD_FORM_QUESTION.STD_FORM_QUESTION_ID, AHOBPR.STD_FORM_QUESTION.TEXT, 
	AHOBPR.STD_FORM_QUESTION.TYPE, AHOBPR.STD_FORM_QUESTION.MIN, AHOBPR.STD_FORM_QUESTION.MAX, AHOBPR.STD_FORM_QUESTION.MAX_CHOICES,
	AHOBPR.STD_FORM_ANSWER.STD_FORM_ANSWER_ID, AHOBPR.STD_FORM_ANSWER.[ORDER], AHOBPR.STD_FORM_ANSWER.TEXT AS ANSWER_TEXT, 
	AHOBPR.STD_FORM_ANSWER.HELP, AHOBPR.STD_FORM_SECTION.BRP_FORM_SECTION_ID, AHOBPR.STD_FORM_SUB_SECTION.BRP_FORM_SUB_SECTION_ID, 
	AHOBPR.STD_FORM_QUESTION.BRP_FORM_QUESTION_ID, AHOBPR.STD_FORM_ANSWER.BRP_FORM_ANSWER_ID 
FROM AHOBPR.STD_FORM, AHOBPR.STD_FORM_SECTION,  AHOBPR.STD_FORM_SUB_SECTION, AHOBPR.STD_FORM_QUESTION, AHOBPR.STD_FORM_ANSWER
WHERE AHOBPR.STD_FORM.STD_FORM_ID = AHOBPR.STD_FORM_SECTION.STD_FORM_ID 
	  AND AHOBPR.STD_FORM_SECTION.STD_FORM_SECTION_ID = AHOBPR.STD_FORM_SUB_SECTION.STD_FORM_SECTION_ID 
	  AND AHOBPR.STD_FORM_SUB_SECTION.STD_FORM_SUB_SECTION_ID = AHOBPR.STD_FORM_QUESTION.STD_FORM_SUB_SECTION_ID
	  AND AHOBPR.STD_FORM_QUESTION.STD_FORM_QUESTION_ID = AHOBPR.STD_FORM_ANSWER.STD_FORM_QUESTION_ID
GO
PRINT N'Creating [AHOBPR].[VIEW_REGISTRANTS]...';


GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANTS] AS
/********************************************************************** 
***********************************************************************/
WITH addr AS
(
   SELECT * 
     FROM AHOBPR.REGISTRANT_ADDRESS 
    WHERE TYPE = 'HOME'
)
SELECT reg.REGISTRANT_ID,
       reg.LAST_NAME + ', ' + reg.FIRST_NAME + ' ' + reg.MIDDLE_NAME AS FULL_NAME,
       reg.BIRTH_DATE,
       DATEDIFF(YEAR, reg.BIRTH_DATE, GETDATE()) AS REGISTRANT_AGE,
       reg.GENDER,
       reg.STD_SERVICE_STATUS_ID,
       reg.STD_REGISTRANT_STATUS_ID,
       reg.STD_INSTITUTION_ID,
       ISNULL(reg.REGISTRANT_STATUS_LAST_UPDATED_DATE, reg.UPDATED) AS STATUS_LAST_UPDATED_DATE,
       DATEDIFF(DAY, ISNULL(reg.REGISTRANT_STATUS_LAST_UPDATED_DATE, reg.UPDATED), GETDATE()) As DAYS_AT_CURRENT_STATUS,
       info.EDIPI_MISMATCHED_FLAG,
       info.EDIPI_VERIFIED_DATE,
       info.EULA_ACCEPTED_DATE,
       info.CONTACT_INFO_VERIFIED_DATE,
       addr.COUNTRY,
       addr.STATE,
       addr.CITY
  FROM AHOBPR.REGISTRANT reg
   LEFT JOIN AHOBPR.[REGISTRANT_RECORD_INFO] info
          ON info.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.REGISTRANT_CONTACT_INFO cont
          ON cont.REGISTRANT_ID = info.REGISTRANT_ID
   LEFT JOIN addr
          ON addr.REGISTRANT_ID = cont.REGISTRANT_ID;
    
   
    -- SELECT * FROM [AHOBPR].[VIEW_REGISTRANTS]
GO
PRINT N'Creating [AHOBPR].[VIEW_HEALTH_FACTOR]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE VIEW [AHOBPR].[VIEW_HEALTH_FACTOR] WITH SCHEMABINDING 
    AS SELECT 
       A.REGISTRANT_HEALTH_FACTOR_ID, 
       A.REGISTRANT_VISIT_ID, 
       D.REGISTRANT_ID, 
       D.VISIT_DATE_TIME AS EVALUATION_DATE_TIME, 
       B.DESCRIPTION AS HEALTH_FACTOR, 
	     C.DESCRIPTION AS HEALTH_FACTOR_CATEGORY, 
	     C.TOOLTIP as CATEGORY_TOOLTIP, 
	     B.SORT_ORDER AS SORT_ORDER, 
	     B.STD_HEALTH_FACTOR_CATEGORY_ID
  FROM AHOBPR.[REGISTRANT_HEALTH_FACTOR] A, 
       AHOBPR.STD_HEALTH_FACTOR B, 
       AHOBPR.STD_HEALTH_FACTOR_CATEGORY C,
	     AHOBPR.REGISTRANT_VISIT D
 WHERE A.STD_HEALTH_FACTOR_ID = B.STD_HEALTH_FACTOR_ID 
   AND B.STD_HEALTH_FACTOR_CATEGORY_ID = C.STD_HEALTH_FACTOR_CATEGORY_ID
   AND A.REGISTRANT_VISIT_ID = D.REGISTRANT_VISIT_ID
   AND D.EVALUATION_FLAG = 'Y'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[VIEW_INSTITUTION]...';


GO
CREATE VIEW [AHOBPR].[VIEW_INSTITUTION]
AS
       SELECT  dbo.STD_INSTITUTION.ID, 
               dbo.STD_INSTITUTION.NAME,
               dbo.STD_INSTITUTION.STATIONNUMBER, 
               dbo.STD_INSTITUTION.VISTANAME, 
               dbo.STD_INSTITUTION.AGENCY_ID,
               dbo.STD_FACILITYTYPE.NAME AS FACILITY_TYPE,
               dbo.STD_INSTITUTION.MFN_ZEG_RECIPIENT, 
               dbo.STD_INSTITUTION.PARENT_ID, 
               dbo.STD_INSTITUTION.REALIGNEDFROM_ID, 
               dbo.STD_INSTITUTION.REALIGNEDTO_ID, 
               dbo.STD_INSTITUTION.VISN_ID, 
               dbo.STD_INSTITUTION.IS_ACTIVE, 
               dbo.STD_INSTITUTION.STREETADDRESSLINE1,  
               dbo.STD_INSTITUTION.STREETCITY, 
               dbo.STD_INSTITUTION.STREETPOSTALCODE, 
               dbo.STD_COUNTRY.SHORTNAME AS COUNTRY_NAME, 
               dbo.STD_COUNTRY.ALPHA3CODE AS COUNTRY_CODE, 
               dbo.STD_STATE.FIPSCODE AS STATE_CODE, 
               dbo.STD_STATE.NAME AS STATE_NAME, 
               dbo.STD_COUNTY.NAME AS COUNTY_NAME, 
               dbo.STD_COUNTY.COUNTYNUMBER, 
               dbo.STD_COUNTY.DESCRIPTION_TEXT AS COUNTY_DESC
         FROM  dbo.STD_INSTITUTION 
         JOIN  dbo.STD_FACILITYTYPE 
           ON  dbo.STD_INSTITUTION.STD_FACILITYTYPE_ID = dbo.STD_FACILITYTYPE.ID 
    LEFT JOIN  dbo.STD_COUNTY 
           ON  dbo.STD_INSTITUTION.STREETCOUNTY_ID = dbo.STD_COUNTY.ID 
    LEFT JOIN  dbo.STD_COUNTRY 
           ON  dbo.STD_INSTITUTION.STREETCOUNTRY_ID = dbo.STD_COUNTRY.ID 
    LEFT JOIN  dbo.STD_STATE 
           ON  dbo.STD_INSTITUTION.STREETSTATE_ID = dbo.STD_STATE.ID;
          
-- SELECT * FROM [AHOBPR].[VIEW_INSTITUTION]         
GO
PRINT N'Creating [AHOBPR].[VIEW_US_LOCATIONS]...';


GO
CREATE VIEW [AHOBPR].[VIEW_US_LOCATIONS]
AS
  SELECT STD_COUNTRY.ID AS COUNTRY_ID,
         STD_COUNTRY.ALPHA3CODE AS COUNTRY_CODE,
         STD_COUNTRY.POSTALNAME AS COUNTRY_NAME,
         STD_STATE.ID AS STATE_ID,
         STD_STATE.POSTALNAME AS STATE_CODE,
         STD_STATE.NAME AS STATE_NAME,
         STD_COUNTY.ID AS COUNTY_ID,
         STD_COUNTY.NAME AS COUNTY_NAME       
    FROM dbo.STD_COUNTY
    JOIN dbo.STD_STATE
      ON STD_STATE.ID = STD_COUNTY.STATE_ID
    JOIN dbo.STD_COUNTRY
      ON STD_COUNTRY.ID = STD_STATE.COUNTRY_ID;
GO
PRINT N'Creating [AHOBPR].[VIEW_ETHNICITY]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE VIEW [AHOBPR].[VIEW_ETHNICITY] WITH SCHEMABINDING 
    AS SELECT 
    ID,
    ABBREVIATION,
    NAME,
    DESCRIPTION_TEXT
  FROM dbo.[STD_ETHNICITY]
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[VIEW_FACILITY_LOOKUP]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE VIEW [AHOBPR].[VIEW_FACILITY_LOOKUP]
AS
SELECT 'Visn' AS LOOKUP_TYPE  
  	   ,CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                      THEN SUBSTRING(visn.NAME, 6, 5) 
                      ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS ID
  	   ,'V'+CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                      THEN SUBSTRING(visn.NAME, 6, 5) 
                      ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS CODE
  	   ,'V'+ CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                  THEN SUBSTRING(visn.NAME, 6, 5) 
                  ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS NAME
       ,0 AS PARENT_ID
       ,CONVERT(INT, SUBSTRING(visn.NAME, 6, 5)) AS SORT_ORDER
       , 'V' + CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                    THEN SUBSTRING(visn.NAME, 6, 5) 
                    ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS VisnID
       ,CONVERT(INT,0) AS BASE_ID
  FROM dbo.STD_INSTITUTION AS visn
 WHERE SUBSTRING(visn.NAME,1,5) = 'VISN '
UNION ALL
SELECT 'MainFacility' AS LOOKUP_TYPE  
	     ,fac.ID
       ,fac.STATIONNUMBER AS CODE
       ,'(V' + SUBSTRING(visn.NAME, 6, 5) + ')(' + fac.STATIONNUMBER + ') ' 
                + fac.NAME + ', ' 
                + ISNULL(fac.STREETCITY, '') + ', ' 
                + ISNULL(S.POSTALNAME, '<blank name>') AS Name
       ,CONVERT(int, SUBSTRING(visn.NAME, 6, 5)) AS PARENT_ID
       ,CONVERT(int, SUBSTRING(visn.NAME, 6, 5)) AS SORT_ORDER
       ,'V' + CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                   THEN SUBSTRING(visn.NAME, 6, 5) 
                   ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS VisnID
       ,fac.ID AS BASE_ID
  FROM     dbo.STD_INSTITUTION visn
  JOIN     dbo.STD_INSTITUTION AS fac ON visn.ID = fac.VISN_ID 
LEFT JOIN  dbo.STD_STATE AS S ON S.ID = fac.STREETSTATE_ID
WHERE SUBSTRING(visn.NAME,1,5) = 'VISN '
  AND LEN(fac.STATIONNUMBER) = 3
UNION ALL
SELECT 'Facility' AS LOOKUP_TYPE  
	     ,fac.ID
       ,fac.STATIONNUMBER AS CODE
       ,'(V' + SUBSTRING(visn.NAME, 6, 5) + ')(' + fac.STATIONNUMBER + ') ' 
                + fac.NAME + ', ' 
                + ISNULL(fac.STREETCITY, '') + ', ' 
                + ISNULL(S.POSTALNAME, '<blank name>') AS Name
       ,base.ID AS  PARENT_ID
       ,CONVERT(int, SUBSTRING(visn.NAME, 6, 5)) AS SORT_ORDER
       ,'V' + CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                   THEN SUBSTRING(visn.NAME, 6, 5) 
                   ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS VisnID
       ,base.ID AS BASE_ID
  FROM     dbo.STD_INSTITUTION visn
  JOIN     dbo.STD_INSTITUTION AS fac ON visn.ID = fac.VISN_ID 
  JOIN     dbo.STD_INSTITUTION base ON base.STATIONNUMBER = SUBSTRING(fac.STATIONNUMBER,1,3)
LEFT JOIN  dbo.STD_STATE AS S ON S.ID = fac.STREETSTATE_ID
 WHERE SUBSTRING(visn.NAME,1,5) = 'VISN '
   AND LEN(fac.STATIONNUMBER) > 3
;
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[VIEW_ETL_LOOKUP]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE VIEW [AHOBPR].[VIEW_ETL_LOOKUP] WITH SCHEMABINDING AS

 WITH src
 AS( 
  SELECT DISTINCT
          'STD_MARITALSTATUS' AS [TYPE],
          [MARITAL_STATUS] AS [DESCRIPTION]
    FROM  [AHOBPR].[REGISTRANT]
  UNION
  SELECT DISTINCT
          'STD_GENDER' AS [TYPE],
          [GENDER]
    FROM  [AHOBPR].[REGISTRANT]
  UNION
  SELECT DISTINCT
          'STD_RACE' AS [TYPE],
          RACE
    FROM  [AHOBPR].[REGISTRANT]
  UNION
  SELECT DISTINCT
          'STD_ELIGIBLITYSTATUS' AS [TYPE],
          ELIGIBILITY_STATUS
    FROM  [AHOBPR].[REGISTRANT]
  UNION
  SELECT DISTINCT
          'STD_ETHNICITY' AS [TYPE],
          [ETHNICITY]
    FROM  [AHOBPR].[REGISTRANT]
 )
 SELECT [TYPE],
        ROW_NUMBER() OVER( ORDER BY [TYPE],[DESCRIPTION] ) AS ID,
        ISNULL([DESCRIPTION],'No Data Available') AS [DESCRIPTION]
   FROM Src;



-- SELECT * FROM [AHOBPR].[VIEW_ETL_LOOKUP]
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[VIEW_INSTITUTION_NAME]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE VIEW [AHOBPR].[VIEW_INSTITUTION_NAME]
AS
       SELECT  dbo.STD_INSTITUTION.ID, 
               dbo.STD_INSTITUTION.NAME,
               dbo.STD_INSTITUTION.STATIONNUMBER, 
               dbo.STD_INSTITUTION.VISTANAME, 
               dbo.STD_INSTITUTION.AGENCY_ID,
               dbo.STD_FACILITYTYPE.NAME AS FACILITY_TYPE,
               dbo.STD_INSTITUTION.PARENT_ID,
               dbo.STD_INSTITUTION.VISN_ID               
         FROM  dbo.STD_INSTITUTION 
         JOIN  dbo.STD_FACILITYTYPE 
           ON  dbo.STD_INSTITUTION.STD_FACILITYTYPE_ID = dbo.STD_FACILITYTYPE.ID 
       UNION
       SELECT -1,
              'No Facitilty Assigned',
              'NULL',
              'No Facitilty Assigned',
              NULL,
              NULL,
              NULL,
              '-1'
              ;
          
-- SELECT TOP(100) * FROM [AHOBPR].[VIEW_INSTITUTION_NAME]         
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[VIEW_LOOKUP]...';


GO
CREATE VIEW [AHOBPR].[VIEW_LOOKUP] WITH SCHEMABINDING AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
   OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME NOT LIKE 'Status Change: %'))
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_FAMILY
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DISCHARGE_CHARACTER;


-- select * from  [AHOBPR].[VIEW_LOOKUP]
GO
PRINT N'Creating [AHOBPR].[SP_ReportGetDutyStatusByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO

-- =============================================
-- Author:		Deborah Barr
-- Create date: December 08, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetDutyStatusByID]
       @dutyStatusId varchar(100) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  DECLARE @dutyStatusDescription varchar(4000) = ''
  DECLARE @dutyStatus varchar(100)
	
  DECLARE curDutyStatus CURSOR 
      FOR
        SELECT SERVICE_STATUS
		FROM AHOBPR.STD_SERVICE_STATUS
		WHERE STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@dutyStatusId, ','))
			OR ISNULL(@dutyStatusId, '') = '';

  OPEN curDutyStatus;
  FETCH NEXT FROM curDutyStatus INTO @dutyStatus;
  WHILE @@FETCH_STATUS = 0  -- Not End of file
	BEGIN
		if  @dutyStatusDescription != ''
			SET @dutyStatusDescription = @dutyStatusDescription + ', '
		
		SET @dutyStatusDescription = @dutyStatusDescription + @dutyStatus;
		FETCH NEXT FROM curDutyStatus INTO @dutyStatus;			
	END		
  CLOSE curDutyStatus;   
  DEALLOCATE curDutyStatus;    
  
  SELECT  @dutyStatusDescription AS DUTY_STATUS_DESCRIPTION 

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetFacilityNameByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: January 07, 2015
-- Description:	Used for the AHOBPR Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetFacilityNameByID]
       @InstitutionId VARCHAR(50) = '0' 
       
AS
 BEGIN
  IF ISNULL(@InstitutionId,'0')  <> '0'
  AND ISNUMERIC(@InstitutionId) = 1
	  SELECT TOP (1) Name
	  FROM AHOBPR.VIEW_FACILITY_LOOKUP
	  WHERE ID =  @InstitutionId;
 END;
-- EXEC [AHOBPR].[SP_ReportGetFacilityNameByID] '1000109'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetStatusByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: December 01, 2014
-- Description:	Used for the AHOBPR Status by Location Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetStatusByID]
       @statusId varchar(100) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  DECLARE @statusDescription varchar(4000) = ''
  DECLARE @status varchar(100)
	
  DECLARE curStatus CURSOR 
      FOR
        SELECT REGISTRANT_STATUS
		FROM AHOBPR.STD_REGISTRANT_STATUS
		WHERE STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@statusId, ','))
			OR ISNULL(@statusId, '') = '';

  OPEN curStatus;
  FETCH NEXT FROM curStatus INTO @status;
  WHILE @@FETCH_STATUS = 0  -- Not End of file
	BEGIN
		if  @statusDescription != ''
			SET @statusDescription = @statusDescription + ', '
		
		SET @statusDescription = @statusDescription + @status;
		FETCH NEXT FROM curStatus INTO @status;			
	END		
  CLOSE curStatus;   
  DEALLOCATE curStatus;    
  
  SELECT  @statusDescription AS STATUS_DESCRIPTION 

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetStateByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: December 01, 2014
-- Description:	Used for the AHOBPR Status by Location Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetStateByID]
       @stateId varchar(1000) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  SELECT  AHOBPR.GetStateCodeByID (@stateId) AS STATE_DESCRIPTION 
END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[ERROR_LOG_Log]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Dave May
-- Create date: 22 July 2012
-- Description:	Used to log errors to the ERROR_LOG table.
-- =============================================
CREATE PROCEDURE AHOBPR.ERROR_LOG_Log
	@ErrorProcedure nvarchar(128),
	@ErrorMessage nvarchar(4000) 
AS
BEGIN
  SET NOCOUNT ON;
  SET IMPLICIT_TRANSACTIONS OFF ;

  DECLARE @User varchar(255) = ORIGINAL_LOGIN();
  DECLARE @Now datetime2(0) = GETDATE();
  
  INSERT 
    INTO [AHOBPR].[ERROR_LOG]
         ([COMPONENT_TYPE]
         ,[ERROR_TYPE]
         ,[ERROR_SOURCE]
         ,[ERROR_MESSAGE]
         ,[CREATEDBY]
         ,[UPDATEDBY]
         ,[UPDATED]
          )
    VALUES
		       ('Database', 
		        'Stored Procedure',
			      @ErrorProcedure,
			      @ErrorMessage,
			      @User,
			      @User,
			      @Now
			     );
      
  RETURN SCOPE_IDENTITY();
END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportEligibility]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 01/20/2015
-- Description:	Used for the AHOBPR Eligibility Report  

-- Modification log

-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportEligibility]
       @status varchar(1000) = NULL, -- Multiple statues, comma-separated values when not NULL
       @adminFlag varchar (10) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL;
    
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE()));                         

    SELECT a.REGISTRANT_ID
		   ,a.SSN
           ,a.LAST_NAME 
           ,a.FIRST_NAME 
           ,a.MIDDLE_NAME
	  FROM AHOBPR.REGISTRANT a
	 WHERE (a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ','))OR ISNULL(@status,'') = '')   
	   AND ((ISNULL(@adminFlag,'') = '')
 	         OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag
                      WHERE adminflag.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@adminFlag, ','))
                        AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID
                        AND adminflag.CREATED BETWEEN @adminFlagFromDate AND @adminFlagToDate)); 			

END

-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportEligibility] 
-- EXECUTE [AHOBPR].[SP_ReportEligibility] @adminFlag = '59,60'
-- EXECUTE [AHOBPR].[SP_ReportEligibility] @status = '1,2,3,4'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetAnswerByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: 1/9/2015
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetAnswerByID]
       @answerId varchar(100) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  DECLARE @answerDescription varchar(4000) = ''
  DECLARE @answer varchar(100)
	
  DECLARE curAnswer CURSOR 
      FOR
        SELECT TEXT
		FROM AHOBPR.STD_FORM_ANSWER
		WHERE STD_FORM_ANSWER_ID IN (SELECT * FROM fncSplit(@answerId, ','))
			OR ISNULL(@answerId, '') = '';

  OPEN curAnswer;
  FETCH NEXT FROM curAnswer INTO @answer;
  WHILE @@FETCH_STATUS = 0  -- Not End of file
	BEGIN
		if  @answerDescription != ''
			SET @answerDescription = @answerDescription + ', '
		
		SET @answerDescription = @answerDescription + @answer;
		FETCH NEXT FROM curAnswer INTO @answer;			
	END		
  CLOSE curAnswer;   
  DEALLOCATE curAnswer;    
  
  SELECT  @answerDescription AS ANSWER_DESCRIPTION 

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetQuestionByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: 1/9/2015
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetQuestionByID]
       @QuestionUniqueId varchar(100) = NULL
       
AS
BEGIN  
	  --SELECT  {fn concat(FORM_QUESTION_UNIQUE_ID, TEXT)} AS QUESTION_DESCRIPTION
	  SELECT  FORM_QUESTION_UNIQUE_ID + '  ' + TEXT AS QuestionDescription 
	  FROM AHOBPR.STD_FORM_QUESTION
	  WHERE FORM_QUESTION_UNIQUE_ID = @QuestionUniqueId

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetFlagNameByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO


-- =============================================
-- Author:		Deborah Barr
-- Create date: 1/9/2015
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetFlagNameByID]
       @FlagId INT = 0 
       
AS
BEGIN  
	  SELECT  REGISTRY_FLAG_NAME
	  FROM AHOBPR.STD_REGISTRY_FLAG
	  WHERE STD_REGISTRY_FLAG_ID = @FlagId

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_UpdateRegistrantResponse]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 4/24/2015
-- Description:	Called after loading Response
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_UpdateRegistrantResponse]
       @registrantId INT = NULL 
AS
BEGIN

  UPDATE AHOBPR.REGISTRANT
     SET [REQUEST_SEEN_RESPONSE] = ( 
                                    SELECT SUBSTRING(ISNULL(d.TEXT,''),1,50) as ResponseText
                                      FROM AHOBPR.FORM_RESPONSE r
                                      JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
                                      JOIN AHOBPR.STD_FORM_QUESTION b  ON a.STD_FORM_QUESTION_ID = b.STD_FORM_QUESTION_ID
                                      JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
                                      JOIN AHOBPR.STD_FORM_ANSWER d ON c.STD_FORM_ANSWER_ID = d.STD_FORM_ANSWER_ID
                                     WHERE  r.REGISTRANT_ID = @registrantId
                                       AND b.FORM_QUESTION_UNIQUE_ID = '7.B'
                                       AND r.STD_FORM_ID = b.STD_FORM_ID
                                   ),
       [HEALTH_CONCERNS_RESPONSE] = (
                                      SELECT Distinct d.TEXT
                                        FROM AHOBPR.FORM_RESPONSE r
                                        JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
                                        JOIN AHOBPR.STD_FORM_QUESTION b    ON a.STD_FORM_QUESTION_ID = b.STD_FORM_QUESTION_ID
                                        JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
                                        JOIN AHOBPR.STD_FORM_ANSWER d      ON c.STD_FORM_ANSWER_ID = d.STD_FORM_ANSWER_ID
                                       WHERE  r.REGISTRANT_ID = @registrantId
                                         AND b.FORM_QUESTION_UNIQUE_ID IN ('3.A','3.B','3.C','3.D','3.E','3.F','3.G','3.H','3.I','3.J','3.K') 
                                         AND d.TEXT = 'Yes'       
                                   ),
        [CONTACT_PREFERENCE] =     (
                                      SELECT SUBSTRING(d.TEXT,1,100)
                                        FROM AHOBPR.FORM_RESPONSE r
                                        JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
                                        JOIN AHOBPR.STD_FORM_QUESTION b    ON a.STD_FORM_QUESTION_ID = b.STD_FORM_QUESTION_ID
                                        JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
                                        JOIN AHOBPR.STD_FORM_ANSWER d      ON c.STD_FORM_ANSWER_ID = d.STD_FORM_ANSWER_ID
                                       WHERE  r.REGISTRANT_ID = @registrantId
                                         AND b.FORM_QUESTION_UNIQUE_ID = '8.A'
                                   )                                                              
  WHERE REGISTRANT_ID = @registrantId;

END;
-- EXECUTE [AHOBPR].[SP_UpdateRegistrantResponse]  105
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_DeleteRegistrantAndResponse]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 4/24/2015
-- Description:	Called after loading Response
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_DeleteRegistrantAndResponse]
       @registrantId INT = NULL 
AS
BEGIN

  DELETE FROM AHOBPR.FORM_RESPONSE_ANSWER
  WHERE FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FORM_RESPONSE_ANSWER_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
            JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE FROM AHOBPR.FORM_RESPONSE_QUESTION
  WHERE FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FORM_RESPONSE_QUESTION_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      
            
  DELETE FROM AHOBPR.FORM_RESPONSE_STATUS
  WHERE FORM_RESPONSE_STATUS_ID IN
         ( 
          SELECT a.FORM_RESPONSE_STATUS_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_STATUS a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      

  DELETE FROM AHOBPR.FORM_RESPONSE   
        WHERE REGISTRANT_ID  = @registrantId;
        
  DELETE FROM AHOBPR.REGISTRANT_DEPLOYMENT   
        WHERE REGISTRANT_ID  = @registrantId;

  DELETE FROM AHOBPR.REGISTRANT_ADDRESS   
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_PHONE
        WHERE REGISTRANT_ID  = @registrantId;  
        
   DELETE FROM AHOBPR.REGISTRANT_EMAIL     
        WHERE REGISTRANT_ID  = @registrantId;  
        
      
  DELETE FROM AHOBPR.REGISTRANT_CONTACT_INFO
        WHERE REGISTRANT_ID  = @registrantId;  
     
  DELETE FROM AHOBPR.REGISTRANT_HEALTH_FACTOR
        WHERE REGISTRANT_VISIT_ID IN
              (SELECT REGISTRANT_VISIT_ID
                 FROM AHOBPR.REGISTRANT_VISIT
                WHERE REGISTRANT_ID = @registrantId);  
        
  DELETE FROM AHOBPR.REGISTRANT_VISIT
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_RECORD_INFO
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_REGISTRY_FLAG
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_SERVICE_EPISODE
        WHERE REGISTRANT_ID  = @registrantId;  
    
  DELETE FROM AHOBPR.PROCESS_METRICS
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT
        WHERE REGISTRANT_ID  = @registrantId;              
END;
-- EXECUTE [AHOBPR].[SP_DeleteRegistrantAndResponse]  140
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_Test]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO

CREATE PROCEDURE [AHOBPR].[SP_Test]
       @RegistrantId INT = 0, @firstName varchar(50) = NULL, @lastName varchar(50) = NULL
AS
BEGIN
	UPDATE AHOBPR.REGISTRANT
	SET FIRST_NAME = @firstName, LAST_NAME = @lastName
	WHERE REGISTRANT_ID = @RegistrantId
	
	SELECT FIRST_NAME, MIDDLE_NAME, LAST_NAME FROM AHOBPR.REGISTRANT WHERE REGISTRANT_ID = @RegistrantId
END

-- EXEC [AHOBPR].[SP_Test] 33, 'Jane', 'Mary', 'Smith'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_RecordEmailLog]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: 2/23/2015
-- Description:	Used to log email
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_RecordEmailLog]
	@templateId as int,
	@registrantId as int,
	@userId as int,
	@eTo varchar(100),	 
	@eCC varchar(100),
	@eBCC varchar(max),
 	@subject varchar(200),
 	@body varchar(max)  ,
	@failed varchar(max),
	@createdBy varchar(30),
	@updatedBy varchar(30)
AS
BEGIN
	SET NOCOUNT ON;
	DECLARE @eId INT
	INSERT INTO
		EMAIL_LOG 
		(TEMPLATE_ID, REGISTRANT_ID, USER_ID ,EMAIL_SENT, EMAIL_TO  ,EMAIL_CC ,EMAIL_BCC ,subject , body, failed, CREATEDBY, UPDATEDBY )
	VALUES
		(@templateId, @registrantId, @userId, getdate(), @eTo, @eCC, @eBCC, @subject, @body, @failed, @createdBy, @updatedBy )

	SET @eId = SCOPE_IDENTITY() 
	SELECT @eId

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_InsertRegistrantFile]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE PROCEDURE [AHOBPR].[SP_InsertRegistrantFile]
	@fileId			varchar(256),
	@fileType		varchar(256),
	@fileContent	varbinary(max),
	@createdBy		varchar(30)
AS
BEGIN
	SET NOCOUNT ON;
	
	DECLARE @registrantFileId	uniqueidentifier;
	
	SELECT	@registrantFileId = registrant_file_id
	FROM	AHOBPR.REGISTRANT_FILE
	WHERE	FILE_ID = @fileId AND
			FILE_TYPE = @fileType;
	
	IF (@registrantFileId is null)
		BEGIN
			INSERT INTO AHOBPR.REGISTRANT_FILE 
				(REGISTRANT_FILE_ID,
				 FILE_ID, 
				 FILE_TYPE, 
				 FILE_CONTENT, 
				 CREATEDBY, 
				 UPDATEDBY, 
				 CREATED, 
				 UPDATED) 
			VALUES
				(NEWID(),
				 @fileId,
				 @fileType,
				 @fileContent,
				 @createdBy,
				 @createdBy,
				 GETDATE(),
				 GETDATE());
		END
	ELSE
		BEGIN
			UPDATE AHOBPR.REGISTRANT_FILE
			SET
				FILE_CONTENT = @fileContent,
				UPDATEDBY = @createdBy,
				UPDATED = GETDATE()
			WHERE REGISTRANT_FILE_ID = @registrantFileId;
		END
END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ResetDatabase]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: 6/12/2015
-- Description:	Called to reset database
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ResetDatabase]
AS

DECLARE @registrantId int
DECLARE @registrantCursor CURSOR
SET @registrantCursor = CURSOR FAST_FORWARD
	FOR
	SELECT REGISTRANT_ID FROM AHOBPR.REGISTRANT 
	WHERE USER_ID IN (SELECT OBJECT_ID FROM AHOBPR.REGISTRANT_JSON)
BEGIN

	OPEN @registrantCursor
	FETCH NEXT FROM @registrantCursor INTO @registrantId
	WHILE @@FETCH_STATUS = 0
		BEGIN
			exec ahobpr.SP_DeleteRegistrantAndResponse @registrantId
			
			FETCH NEXT FROM @registrantCursor INTO @registrantId
		END
	CLOSE @registrantCursor
	DEALLOCATE @registrantCursor

	DELETE FROM [AHOBPR].[JSON_queue]
	DELETE FROM [AHOBPR].[REGISTRANT_JSON] WHERE OBJECT_TYPE <> 'form'

END

-- EXEC [AHOBPR].[SP_ResetDatabase]
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_DeleteOneRegistrant]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: 7/6/2015
-- Description:	Called to delete one registrant from database
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_DeleteOneRegistrant]
	@firstName  VARCHAR(50),
	@lastName  VARCHAR(50)
AS

DECLARE @registrantId int
BEGIN
	
	SELECT @registrantId = REGISTRANT_ID FROM [AHOBPR].[REGISTRANT] WHERE FIRST_NAME = @firstName AND LAST_NAME = @lastName
	exec ahobpr.SP_DeleteRegistrantAndResponse @registrantId

	DELETE FROM [AHOBPR].[REGISTRANT_JSON] WHERE OBJECT_ID IN 
		(SELECT OBJECT_ID FROM [AHOBPR].[REGISTRANT_JSON] WHERE JSON_DATA like '%' + @firstName + '%' AND JSON_DATA like '%' + @lastName + '%')

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportAdHocByIndividual]...';


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters and remove NULLs from display where possible
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-03-30 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 2015-04-27 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce CLegg - Rewrote as Dynamic SQL for performance
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByIndividual]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = ''
AS

BEGIN

PRINT 'Starting....';

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText)); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
 --PRINT @SubPopWith;
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';
--PRINT @AdminWith;
  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';
--PRINT @DeployWith;

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';

  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT ra.STD_FORM_ANSWER_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' +
                                              ' WHERE ra.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID ' + 
                                               '  AND ra.STD_FORM_ANSWER_ID IN (' + @answer + ') )';

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';

  PRINT CONVERT(VARCHAR(20),@formStartToDate,121);
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
     
    PRINT @MainQuery;
    PRINT LEN(@MainQuery);
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';
  
    PRINT @MainQuery;


  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
    
    PRINT @MainQuery;

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';
  PRINT @MainQuery;
	IF ISNULL(@adminFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
    PRINT @MainQuery;                                                
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
   PRINT @MainQuery;                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

  PRINT @MainQuery;  
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID = ''1.2.A'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                                      
  PRINT @MainQuery;
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @RegCriteria = @RegCriteria + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
    
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;

-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @questionNumber = '1.2.E'  , @answer = '2346,1571,17'  
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]  @ethnicity = 'JEWISH'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'
GO
PRINT N'Creating [AHOBPR].[SP_ReportRegistrantStatusAging]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 8, 2015
-- Description:	Used for the AHOBPR Aging Report  -- exec [AHOBPR].[SP_ReportRegistrantStatusAging]    (More options at bottom)
-- Note: All 7 Registrant Status rows will be returned as possible values, so some rows may have all zeros.
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150710 - Bruce Clegg - Rewrite using Dynamic SQL for Performance
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantStatusAging]
       @AsOfDate              DATETIME2(0) = NULL,  
       @SvcStatus             VARCHAR(50)  = '',     -- 'Veteran', 'Retiree', 'Active Duty'
       @AssignedLocationType  VARCHAR(20)  = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50)  = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20)  = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50)  = NULL   -- 'V16', 'V01'    1000109,  1000089
AS
BEGIN

  SET @AsOfDate = dbo.AddMaxTime(ISNULL(@AsOfDate,GETDATE()));  -- adds 23:59:59

  DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

  DECLARE @Query VARCHAR(8000);

  IF @AssignedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@AssignedLocationKey) = 1
    SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
  IF @EvaluatedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@EvaluatedLocationKey) = 1
    SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  SET @Query = 'WITH MostRecent AS ( ' +  
      'SELECT Metrics.REGISTRANT_ID,  ' +
             'MAX(Metrics.PROCESS_METRICS_ID) AS MaxMetricsID ' +
        'FROM [AHOBPR].[PROCESS_METRICS] Metrics ' +
        'JOIN AHOBPR.STD_PROCESS_METRICS_TYPE ProcessType ' +
          'ON ProcessType.STD_PROCESS_METRICS_TYPE_ID = Metrics.STD_PROCESS_METRICS_TYPE_ID ' +
       'WHERE ProcessType.PROCESS_METRICS = ''Registrant Status Change''  ' +
         'AND Metrics.CREATED <= ''' + CONVERT(VARCHAR(20),@AsOfDate,121) + ''' ' +
       'GROUP BY [REGISTRANT_ID] ' +
   '),  Stat   AS ( ' +
      'SELECT this.[REGISTRANT_ID],  ' +
             'this.PROCESS_METRICS_VALUE,  ' +
             'this.CREATED AS StatusDate, ' +
             'DATEDIFF(DAY, this.CREATED, ''' + CONVERT(VARCHAR(20),@AsOfDate,121) + ''') AS DaysDiff ' +
        'FROM [AHOBPR].[PROCESS_METRICS] this ' +
        'JOIN MostRecent ON MostRecent.MaxMetricsID = this.PROCESS_METRICS_ID ' +
    '),  Summary  AS (   ' +
      'SELECT Stat.PROCESS_METRICS_VALUE, ' +
             'SUM(CASE WHEN( Stat.DaysDiff < 31) THEN 1 ELSE 0 END) AS Age0to30, ' +
             'SUM(CASE WHEN( Stat.DaysDiff BETWEEN 31 AND 60) THEN 1 ELSE 0 END) AS Age31to60, ' +
             'SUM(CASE WHEN( Stat.DaysDiff BETWEEN 61 AND 90) THEN 1 ELSE 0 END) AS Age61to90, ' +
             'SUM(CASE WHEN( Stat.DaysDiff > 90) THEN 1 ELSE 0 END) AS Age91plus,  ' +
             'Count(*) AS TotalCount ' +
	      'FROM AHOBPR.REGISTRANT reg ' +
	      'JOIN Stat ON reg.REGISTRANT_ID = Stat.REGISTRANT_ID ' +
		    'JOIN AHOBPR.STD_SERVICE_STATUS svc ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID ' +
        'WHERE 1 = 1 ';

  IF ISNULL(@SvcStatus,'') != ''
    SET @Query = @Query + ' AND svc.SERVICE_STATUS = ''' + @SvcStatus + '''';
	            
  IF @AssignedLocationType = 'NLA' 
    SET @Query = @Query + ' AND reg.STD_INSTITUTION_ID IS NULL ';

  IF @AssignedLocationType = 'VISN' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                      ' WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
 	
  IF @AssignedLocationType = 'Base' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                       'WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' ) ';
            	
  IF @AssignedLocationType = 'Institution' 
    SET @Query = @Query + ' AND reg.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' '	
  
  IF @EvaluatedLocationType = 'NLA' 
    SET @Query = @Query + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                            'WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                               'AND eval.EVALUATION_FLAG = ''Y'' ) ';
          
  IF @EvaluatedLocationType = 'VISN' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                                'AND inst.VisnID = ''' +  @EvaluatedLocationKey + ''' ' +
                                                'AND eval.EVALUATION_FLAG = ''Y'') ' ; 
         	
  IF @EvaluatedLocationType = 'Base' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + 
             	                          ' AND eval.EVALUATION_FLAG = ''Y'') '; 
  IF @EvaluatedLocationType = 'Institution' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                      ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID '+
                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) +
                                        ' AND eval.EVALUATION_FLAG = ''Y'') '; 
           
                
  SET @Query = @Query + ' GROUP BY Stat.PROCESS_METRICS_VALUE  ) ' +       
    'SELECT Possible.ORDINAL_VALUE,  ' +
           'Possible.REGISTRANT_STATUS, ' +
           'ISNULL(Summary.Age0to30,0)    AS Age0to30, ' +
           'ISNULL(Summary.Age31to60, 0)  AS Age31to60, ' +
           'ISNULL(Summary.Age61to90, 0)  AS Age61to90, ' +
           'ISNULL(Summary.Age91plus, 0)  AS Age91plus, ' +
           'ISNULL(Summary.TotalCount, 0) AS TotalCount ' +
      'FROM [AHOBPR].[STD_REGISTRANT_STATUS] Possible ' +
      'LEFT JOIN Summary ON Summary.PROCESS_METRICS_VALUE = Possible.REGISTRANT_STATUS ' +
     ' ORDER BY Possible.ORDINAL_VALUE' + 
     ' OPTION (OPTIMIZE FOR UNKNOWN); ' ;
     
   PRINT @Query;
   
   EXECUTE(@Query);                             
END

-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20141130'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150130', 'Veteran'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150122', 'Retiree'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150122', 'Active Duty'

-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportParticipation]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Dec 30, 2014
-- Description:	Used for the AHOBPR Participation Report       -- exec [AHOBPR].[SP_ReportParticipation] 
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150710 - Bruce Clegg - Rewrite using Dynamic SQL for Performance
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportParticipation]
       @StartDate DATETIME2(0) = NULL,  
       @EndDate   DATETIME2(0) = NULL,
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL   -- 'V16', 'V01'    1000109,  1000089
AS
BEGIN

  SET @StartDate = ISNULL(@StartDate,'19900802'); -- Desert Storm start date
  SET @EndDate = ISNULL(@EndDate, GetDate());
  
  DECLARE @ConsentStatusCount INT = 0,
          @EligibleStatusCount INT = 0,
          @ParticipantStatusCount INT = 0,
          @HealthConcernsCount INT = 0,
          @NoHealthConcernsCount INT = 0,
          @RequestSeenCount INT = 0,
          @NoRequestSeenCount INT = 0,
          @DoNotKnowRequestSeenCount INT = 0,
          @VeteranServiceStatusCount INT = 0,
          @ActiveDutyServiceStatusCount INT = 0,
          @RetireeServiceStatusCount INT = 0,
          @Afgh911Count INT = 0,
          @Iraq911Count INT = 0,
          @SWA911Count INT = 0,
          @Pre911Count INT = 0,
          @Djibouti911Count INT = 0,
          @MedianDaysToParticipant DECIMAL(9,2) = 0;    
  
  DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

  DECLARE @Query NVARCHAR(MAX);
  DECLARE @Criteria VARCHAR(2000) = '';

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --  Build Criteria string

  SET @Criteria = ' AND responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN ''' + CONVERT(VARCHAR(20),@StartDate,121) +
                                                                    ''' AND ''' + CONVERT(VARCHAR(20),@EndDate,121) + ''' ' ;
  IF @AssignedLocationType = 'NLA' 
    SET @Criteria = @Criteria + ' AND reg.STD_INSTITUTION_ID IS NULL ';

  IF @AssignedLocationType = 'VISN' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                      ' WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
 	
  IF @AssignedLocationType = 'Base' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                       'WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' ) ';
            	
  IF @AssignedLocationType = 'Institution' 
    SET @Criteria = @Criteria + ' AND reg.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' '	
  
  IF @EvaluatedLocationType = 'NLA' 
    SET @Criteria = @Criteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                            'WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                               'AND eval.EVALUATION_FLAG = ''Y'' ) ';
          
  IF @EvaluatedLocationType = 'VISN' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                                'AND inst.VisnID = ''' +  @EvaluatedLocationKey + ''' ' +
                                                'AND eval.EVALUATION_FLAG = ''Y'') ' ; 
         	
  IF @EvaluatedLocationType = 'Base' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + 
             	                          ' AND eval.EVALUATION_FLAG = ''Y'') '; 
  IF @EvaluatedLocationType = 'Institution' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                      ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID '+
                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) +
                                        ' AND eval.EVALUATION_FLAG = ''Y'') '; 

  --  @ParticipantStatusCount
  SET @Query = ' SELECT @ParticipantStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + @Criteria     
              + '  AND stat.REGISTRANT_STATUS = ''Participant'' '; 
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@ParticipantStatusCount INT OUTPUT',    @ParticipantStatusCount OUTPUT;

   
    --  @HealthConcernsCount
  SET @Query = ' SELECT @HealthConcernsCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.HEALTH_CONCERNS_RESPONSE = ''Yes'' '
              + @Criteria; 
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@HealthConcernsCount INT OUTPUT',    @HealthConcernsCount OUTPUT;

  --  @NoHealthConcernsCount
  SET @Query = ' SELECT @NoHealthConcernsCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.HEALTH_CONCERNS_RESPONSE IS NULL '
              + @Criteria; 
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@NoHealthConcernsCount INT OUTPUT',    @NoHealthConcernsCount OUTPUT;
                           

  --  @RequestSeenCount
  SET @Query = ' SELECT @RequestSeenCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.REQUEST_SEEN_RESPONSE = ''Yes'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@RequestSeenCount INT OUTPUT',    @RequestSeenCount OUTPUT;
                                                     
  --  @NoRequestSeenCount
  SET @Query = ' SELECT @NoRequestSeenCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.REQUEST_SEEN_RESPONSE = ''No'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@NoRequestSeenCount INT OUTPUT',    @NoRequestSeenCount OUTPUT;
                                                                                         
  --  @DoNotKnowRequestSeenCount
  SET @Query = ' SELECT @DoNotKnowRequestSeenCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE ISNULL(reg.REQUEST_SEEN_RESPONSE,'''') NOT IN (''Yes'',''No'') '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@DoNotKnowRequestSeenCount INT OUTPUT', @DoNotKnowRequestSeenCount OUTPUT;      
                                                   
  --  @ActiveDutyServiceStatusCount
  SET @Query = ' SELECT @ActiveDutyServiceStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
                '  JOIN AHOBPR.STD_SERVICE_STATUS svc  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID '
              + ' WHERE svc.SERVICE_STATUS = ''Active Duty'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@ActiveDutyServiceStatusCount INT OUTPUT', @ActiveDutyServiceStatusCount OUTPUT;        
         
   
  --  @VeteranServiceStatusCount
  SET @Query = ' SELECT @VeteranServiceStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
                '  JOIN AHOBPR.STD_SERVICE_STATUS svc  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID '
              + ' WHERE svc.SERVICE_STATUS = ''Separated'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@VeteranServiceStatusCount INT OUTPUT', @VeteranServiceStatusCount OUTPUT;                    
 
  --  @RetireeServiceStatusCount
  SET @Query = ' SELECT @RetireeServiceStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
                '  JOIN AHOBPR.STD_SERVICE_STATUS svc  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID '
              + ' WHERE svc.SERVICE_STATUS = ''Retiree'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@RetireeServiceStatusCount INT OUTPUT', @RetireeServiceStatusCount OUTPUT;                    
 
     
                                                         
-- Deployment Counts  
  SET @Query = 'WITH Deployments
  AS ( 
    SELECT 
        dply.REGISTRANT_ID ,
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = ''Iraq'' 
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                           THEN 1 ELSE 0 END) )> 0 
           THEN 1 ELSE 0 END AS Iraq911Count,
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = ''Afghanistan''  
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS Afgh911Count,              
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = ''Djibouti''  
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS Djibouti911Count,              
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] IN (''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'')
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                           THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS SWA911Count,
      CASE WHEN (SUM(CASE WHEN ([DEPLOYMENT_START_DATE] BETWEEN ''19900802'' AND ''20010911'' ) 
                           AND  [DEPLOYMENT_COUNTRY] IN (''Iraq'',''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'')
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END  AS Pre911Count
    FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] dply
        JOIN AHOBPR.REGISTRANT Reg ON Reg.REGISTRANT_ID = dply.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = dply.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID   
        JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON dply.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
	      JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
	     WHERE quest.FORM_QUESTION_UNIQUE_ID = ''1.2.A'' ' +
	     @Criteria +                
    ' GROUP BY dply.REGISTRANT_ID 
     )
     SELECT @Afgh911Count =  SUM(ISNULL(Deployments.Afgh911Count,0))  
           ,@Iraq911Count =  SUM(ISNULL(Deployments.Iraq911Count,0))
           ,@SWA911Count = SUM(ISNULL(Deployments.SWA911Count,0))
           ,@Pre911Count =   SUM(ISNULL(Deployments.Pre911Count,0))
           ,@Djibouti911Count = SUM(ISNULL(Deployments.Djibouti911Count,0))
      FROM Deployments' ;
      
  PRINT @Query;
  EXEC sp_executesql @Query,  
       N'@Afgh911Count INT OUTPUT, @Iraq911Count INT OUTPUT, @SWA911Count INT OUTPUT, @Pre911Count INT OUTPUT, @Djibouti911Count INT OUTPUT'
      , @Afgh911Count OUTPUT, @Iraq911Count OUTPUT, @SWA911Count OUTPUT, @Pre911Count OUTPUT, @Djibouti911Count OUTPUT;            

  
     CREATE TABLE #DaysToParticipant(DAYS INT);
   
    -- Median Days from Eligible to Participant Status    
    -- Note that only Registrants with Both values and DateParticipant > DateEligible will be counted for either Numerator or Denominator

    SET @Query = 'WITH eligible 
      AS ( 
          SELECT [REGISTRANT_ID],MIN([CREATED]) AS DateEligible
            FROM [AHOBPR].[PROCESS_METRICS]
           WHERE [PROCESS_METRICS_VALUE] = ''Eligible''
           GROUP BY [REGISTRANT_ID]
         ),
      participant 
      AS (
         SELECT [REGISTRANT_ID],MAX([CREATED]) AS DateParticipant
           FROM [AHOBPR].[PROCESS_METRICS]
          WHERE [PROCESS_METRICS_VALUE] = ''Participant''   
           GROUP BY [REGISTRANT_ID]
          )
     INSERT INTO #DaysToParticipant(DAYS)
    SELECT 
      CASE WHEN DateParticipant > DateEligible THEN DATEDIFF(Day,DateEligible,DateParticipant) ELSE 0 END AS DaysDifference
      FROM [AHOBPR].[REGISTRANT] reg
      JOIN eligible ON reg.REGISTRANT_ID = eligible.REGISTRANT_ID
      JOIN participant ON reg.REGISTRANT_ID = participant.REGISTRANT_ID   
      JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
      JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
    'WHERE 1 = 1 '  + @Criteria +  
   ' ORDER BY DaysDifference';

  PRINT @Query;
  EXECUTE(@Query);
     
    WITH Counts AS
    (
       SELECT c=COUNT(*)
       FROM #DaysToParticipant
    )
    SELECT @MedianDaysToParticipant = AVG(0. + DAYS)
    FROM Counts a
    CROSS APPLY
    (
       SELECT TOP(((a.c - 1) / 2) + (1 + (1 - a.c % 2)))
          DAYS, r=ROW_NUMBER() OVER (ORDER BY DAYS)
       FROM #DaysToParticipant b
       ORDER BY DAYS
    ) p
    WHERE r BETWEEN ((a.c - 1) / 2) + 1 AND (((a.c - 1) / 2) + (1 + (1 - a.c % 2))); 
         
    DROP  TABLE #DaysToParticipant;                   
 
 -- Return Results
   SELECT ISNULL(@ParticipantStatusCount,0) AS ParticipantStatusCount,
          ISNULL(@HealthConcernsCount,0) AS ReportedHealthConcernsCount,
          ISNULL(@NoHealthConcernsCount,0) AS  NoReportedHealthConcernsCount,
          ISNULL(@RequestSeenCount,0) AS RequestSeenCount,
          ISNULL(@NoRequestSeenCount,0) AS NoRequestSeenCount,
          ISNULL(@DoNotKnowRequestSeenCount,0) AS DoNotKnowRequestSeenCount,
          ISNULL(@VeteranServiceStatusCount,0) AS VeteranServiceStatusCount ,
          ISNULL(@ActiveDutyServiceStatusCount,0) AS  ActiveDutyServiceStatusCount,
          ISNULL(@RetireeServiceStatusCount,0) AS RetireeServiceStatusCount,
          ISNULL(@Afgh911Count,0) AS  Afgh911Count,
          ISNULL(@Iraq911Count,0) AS Iraq911Count,
          ISNULL(@SWA911Count,0) AS  SouthWestAsia911Count,
          ISNULL(@Pre911Count,0) AS  Pre911Count,
          ISNULL(@MedianDaysToParticipant,0.0) AS MedianDaysToParticipant,
          ISNULL(@Djibouti911Count,0) AS Djibouti911Count ;

END

-- exec [AHOBPR].[SP_ReportParticipation]
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipation]
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ClearProcessMetrics]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: July, 13 2015
-- Description: Called from Mirgation routine to remove any Process Metrics records created, 
--              as they do not have vaild dates.
CREATE PROCEDURE [AHOBPR].[SP_ClearProcessMetrics] AS
BEGIN
	SET NOCOUNT ON;

	TRUNCATE TABLE [AHOBPR].[PROCESS_METRICS];

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportParticipantDetails]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 5, 2015
-- Description:	Used for the AHOBPR Participation Report Drilldown  -- exec [AHOBPR].[SP_ReportParticipantDetails]    (More options at bottom)
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150504 - Bruce Clegg - Fix @RequestSeen selection logic to match Participation Report
-- 20150710 - Bruce Clegg - Rewrite using Dynamic SQL for Performance
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportParticipantDetails]
       @StartDate DATETIME2(0) = NULL,  
       @EndDate DATETIME2(0) = NULL,
       @RegistrantStatus  VARCHAR(50) = '',  -- 'Participant', 'Review - Not Eligible', 'Eligible', 'No Consent', 'Consent', 'Review'
       @SvcStatus  VARCHAR(50) = '',         -- 'Veteran', 'Retiree', 'Active Duty'
       @RequestSeen  VARCHAR(50) = '',       -- 'Yes', 'No', 'Unknown'
       @HealthConcern  VARCHAR(50) = '',     -- 'Yes', 'No'
       @DeploymentGroup VARCHAR(50) = '',    -- 'Afgh911', 'Iraq911', 'SouthwestAsiaAfter911', 'Pre911',  'DjiboutiAfter911'
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL   -- 'V16', 'V01'    1000109,  1000089
AS
BEGIN

  SET @StartDate = ISNULL(@StartDate,'19900802');
  SET @EndDate = ISNULL(@EndDate, GetDate());
  SET @EndDate = dbo.AddMaxTime(@EndDate);  -- Adds 23:59:59 to criteria parameter

  DECLARE @AssignedInstitutionId INT = 0,
          @EvaluatedInstitutionId INT = 0;
  DECLARE @Query NVARCHAR(MAX);

  IF @AssignedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@AssignedLocationKey) = 1
    SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
  IF @EvaluatedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@EvaluatedLocationKey) = 1
    SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Temp table for Deployments
  CREATE TABLE #Deployments
  (
	   [REGISTRANT_ID] INT
  ); 
  
  -- INSERT Registrants if they are in the Deployment Group
  SET @Query = ' INSERT INTO #Deployments([REGISTRANT_ID]) ' +
               ' SELECT DISTINCT deployment.REGISTRANT_ID ' +
               '   FROM AHOBPR.REGISTRANT_DEPLOYMENT deployment  ' +
               '   JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure  ON deployment.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
               '   JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
               '  WHERE quest.FORM_QUESTION_UNIQUE_ID = ''1.2.A''';
  IF @DeploymentGroup = 'Afgh911'    
     SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] = ''Afghanistan'' ' + 
                            ' AND [DEPLOYMENT_START_DATE] > ''20010911'' ';
  ELSE
  IF @DeploymentGroup = 'Iraq911'
      SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] = ''Iraq'' ' + 
                              'AND [DEPLOYMENT_START_DATE] > ''20010911'' '; 
  ELSE
  IF @DeploymentGroup = 'DjiboutiAfter911'
      SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] = ''Djibouti'' ' + 
                              'AND [DEPLOYMENT_START_DATE] > ''20010911'' '; 
  ELSE
  IF @DeploymentGroup = 'SouthwestAsiaAfter911'
      SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] IN (''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'') ' +
                             'AND [DEPLOYMENT_START_DATE] > ''20010911''  ';
  ELSE
  IF @DeploymentGroup = 'Pre911'
      SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] IN (''Iraq'',''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'') ' +     
                             ' AND [DEPLOYMENT_START_DATE] BETWEEN ''19900802'' AND ''20010911''  ';
  IF ISNULL(@DeploymentGroup,'') > ''
    EXECUTE(@Query);
   
  SET @Query = '
    WITH eligible 
      AS ( 
          SELECT [REGISTRANT_ID],MIN([CREATED]) AS DateEligible
            FROM [AHOBPR].[PROCESS_METRICS]
           WHERE [PROCESS_METRICS_VALUE] IN (''Eligible'',''Reviewed - Eligible'')
           GROUP BY [REGISTRANT_ID]
         ),
      participant 
      AS (
         SELECT [REGISTRANT_ID], MAX([CREATED]) AS DateParticipant
           FROM [AHOBPR].[PROCESS_METRICS]
          WHERE [PROCESS_METRICS_VALUE] = ''Participant''   
          GROUP BY [REGISTRANT_ID]
          )        
  	SELECT reg.REGISTRANT_ID
		     ,(reg.LAST_NAME + '', '' + reg.FIRST_NAME) AS Name
		     ,stat.REGISTRANT_STATUS
		     ,svc.SERVICE_STATUS
		     ,QUESTIONNAIRE_COMPLETED_DATE
		     ,ISNULL(reg.REQUEST_SEEN_RESPONSE, ''Unknown'') AS REQUEST_SEEN_RESPONSE
		     ,ISNULL(reg.HEALTH_CONCERNS_RESPONSE,''No'') AS HEALTH_CONCERNS_RESPONSE
		     ,ISNULL(inst.Name,'''') AS InstitutionName
		     ,CONVERT(VARCHAR(10), responseStat.QUESTIONNAIRE_COMPLETED_DATE, 101) AS QUESTIONNAIRE_COMPLETED_Display
		     ,CASE WHEN DateParticipant > DateEligible THEN DATEDIFF(Day,DateEligible,DateParticipant) ELSE 0 END AS DaysEligibleToParticipant
         ,reg.BIRTH_DATE AS BirthDate
         ,CONVERT(VARCHAR(10), reg.BIRTH_DATE, 101) AS BirthDateDisplay
	  FROM AHOBPR.REGISTRANT reg
		JOIN AHOBPR.STD_REGISTRANT_STATUS stat 
		  ON reg.STD_REGISTRANT_STATUS_ID = stat.STD_REGISTRANT_STATUS_ID
		JOIN AHOBPR.STD_SERVICE_STATUS svc
		  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID
		JOIN AHOBPR.FORM_RESPONSE resp 
		  ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
		JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
		  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID
    JOIN eligible 
      ON reg.REGISTRANT_ID = eligible.REGISTRANT_ID
    JOIN participant 
      ON reg.REGISTRANT_ID = participant.REGISTRANT_ID   		  
		LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst
		  ON inst.ID = reg.STD_INSTITUTION_ID
 	 WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN ''' +CONVERT(VARCHAR(20), @StartDate,121) + 
                                                   ''' AND ''' + CONVERT(VARCHAR(20), @EndDate,121) + ''' ';

  IF ISNULL(@RegistrantStatus,'') > ''
	  SET @Query = @Query + ' AND stat.REGISTRANT_STATUS = ''' + @RegistrantStatus + ''' ';

  IF ISNULL(@SvcStatus,'') > ''
	  SET @Query = @Query + ' AND svc.SERVICE_STATUS = ''' +  @SvcStatus + ''' ';

  IF ISNULL(@HealthConcern,'') > ''
	  SET @Query = @Query + ' AND ISNULL(reg.HEALTH_CONCERNS_RESPONSE,''No'') = ''' +  @HealthConcern + ''' ';

  IF ISNULL(@RequestSeen,'') > ''
	  SET @Query = @Query + 'AND ISNULL(reg.REQUEST_SEEN_RESPONSE, ''Unknown'') = ''' +  @RequestSeen + ''' ';

  IF ISNULL(@DeploymentGroup,'') > ''
	  SET @Query = @Query + 'AND EXISTS(SELECT * FROM #Deployments WHERE #Deployments.REGISTRANT_ID = reg.REGISTRANT_ID) ';

  IF @AssignedLocationType = 'NLA' 
    SET @Query = @Query + ' AND reg.STD_INSTITUTION_ID IS NULL ' ;

  IF @AssignedLocationType = 'VISN' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                          ' WHERE inst.ID = reg.STD_INSTITUTION_ID ' + 
                                                          '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
 
  IF @AssignedLocationType = 'Base' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                  ' WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                                  '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
 
  IF @AssignedLocationType = 'Institution' 
    SET @Query = @Query + ' AND reg.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);

  IF @EvaluatedLocationType = 'NLA' 
    SET @Query = @Query + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                        ' WHERE eval.REGISTRANT_VISIT_ID = reg.REGISTRANT_ID ' +
                                                        '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
 
  IF @EvaluatedLocationType = 'VISN' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                    ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                  ' WHERE eval.REGISTRANT_VISIT_ID = reg.REGISTRANT_ID ' +
                                                    ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                    ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
 
  IF @EvaluatedLocationType = 'Base' 
    SET @Query = @Query +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                    ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                  ' WHERE eval.REGISTRANT_VISIT_ID = reg.REGISTRANT_ID ' +
                                                    ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                    ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
  
  IF @EvaluatedLocationType = 'Institution' 
    SET @Query = @Query +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                    ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                  ' WHERE eval.REGISTRANT_VISIT_ID = reg.REGISTRANT_ID ' +
                                                    ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                    ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 

  SET @Query = @Query + ' ORDER BY responseStat.QUESTIONNAIRE_COMPLETED_DATE ';

  PRINT @Query;
  
  EXECUTE(@Query);
      
  DROP TABLE #Deployments;                                                                                                       
END

-- exec [AHOBPR].[SP_ReportParticipantDetails] 
-- exec [AHOBPR].[SP_ReportParticipantDetails] '20140101', '20150101', NULL, NULL, 'Unknown'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, 'Participant'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, 'Separated'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, 'Yes'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, 'No'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, 'Unknown'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, 'Yes'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, 'No'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'Afgh911'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'Iraq911'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'SouthwestAsiaAfter911'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'DjiboutiAfter911'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'Pre911'

-- exec [AHOBPR].[SP_ReportParticipantDetails]
-- exec [AHOBPR].[SP_ReportParticipantDetails] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipantDetails]
-- exec [AHOBPR].[SP_ReportParticipantDetails] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportContactHistory]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Object:      StoredProcedure [AHOBPR].[SP_ReportContactHistory]
-- Author:		  Bruce Clegg
-- Create date: 21 May 2015
-- Description:	Make 4 tables look like one
--
-- Modification Log:
-- 2015.05.21 Bruce Clegg - Create Procedure
-- 2015.07.14 CleggB - changed UpdatedDate and output from Date to DateTime2(0)
CREATE PROCEDURE [AHOBPR].[SP_ReportContactHistory]
	@RegistrantId INT = NULL 
WITH EXECUTE AS OWNER
AS
BEGIN

  DECLARE @RowCount SMALLINT = 0;

  DECLARE @Results TABLE(UpdatedDate        DATETIME2(0)
                         ,[STREET1]         VARCHAR(256)
                         ,[STREET2]         VARCHAR(256)
                         ,[CITY]            VARCHAR(100)
                         ,[STATE]           VARCHAR(100)
                         ,[ZIP]             VARCHAR(15)
                         ,[COUNTRY]         VARCHAR(100) 
                         ,PhoneNumber       VARCHAR(50)
                         ,MobileNumber      VARCHAR(50)
                         ,EMAIL             VARCHAR(256)  );  
                             
  DECLARE  @UpdatedDate    DATETIME2(0)
          ,@MyOrder        INT
          ,@Street1        VARCHAR(256)
          ,@Street2        VARCHAR(256)
          ,@City           VARCHAR(100)
          ,@State          VARCHAR(100)
          ,@Zip            VARCHAR(15)
          ,@Country        VARCHAR(100) 
          ,@PhoneNumber    VARCHAR(50)
          ,@MobileNumber   VARCHAR(50)
          ,@Email          VARCHAR(256);     

  DECLARE  @UpdatedDateOut    DATETIME2(0)
          ,@Street1Out        VARCHAR(256)
          ,@Street2Out        VARCHAR(256)
          ,@CityOut           VARCHAR(100)
          ,@StateOut          VARCHAR(100)
          ,@ZipOut            VARCHAR(15)
          ,@CountryOut        VARCHAR(100) 
          ,@PhoneNumberOut    VARCHAR(50)
          ,@MobileNumberOut   VARCHAR(50)
          ,@EmailOut          VARCHAR(256);                                        

  DECLARE MyCursor CURSOR LOCAL
  FOR
  WITH Addr
  AS (
      SELECT DISTINCT
             [REGISTRANT_ID]
            ,[STREET1]
            ,[STREET2]
            ,[CITY]
            ,[STATE]
            ,[ZIP]
            ,[COUNTRY]
            ,[Audit_Date] AS UpdatedDate
            ,CONVERT(INT,'1') AS MyOrder
        FROM [AHOBPR].[REGISTRANT_ADDRESS_H]
       WHERE [Audit_Type] != 'DELETE'
         AND [REGISTRANT_ID] = @RegistrantId
     )
    ,Phone
    AS (
        SELECT DISTINCT
               [REGISTRANT_ID]
              ,[PHONE_NUMBER] as PhoneNumber
              ,[Audit_Date] AS UpdatedDate
              ,CONVERT(INT,'2') AS MyOrder          
          FROM [AHOBPR].[REGISTRANT_PHONE_H]
         WHERE ISNULL([TYPE],'') != 'Mobile'
           AND [Audit_Type] != 'DELETE'
           AND [REGISTRANT_ID] = @RegistrantId      
        )
    ,Mobile
    AS (
        SELECT DISTINCT
               [REGISTRANT_ID]
              ,[PHONE_NUMBER] AS MobileNumber
              ,[Audit_Date] AS UpdatedDate
              ,CONVERT(INT,'3') AS MyOrder
          FROM [AHOBPR].[REGISTRANT_PHONE_H]
         WHERE [TYPE] = 'Mobile'
           AND [Audit_Type] != 'DELETE'
           AND [REGISTRANT_ID] = @RegistrantId          
        )  
   ,Email
   AS (
       SELECT DISTINCT 
              [REGISTRANT_ID]
             ,[EMAIL]
             ,[Audit_Date] AS UpdatedDate
             ,CONVERT(INT,'4') AS MyOrder          
         FROM [AHOBPR].[REGISTRANT_EMAIL_H]
        WHERE [Audit_Type] != 'DELETE'
          AND [REGISTRANT_ID] = @RegistrantId          
       )
        SELECT Addr.UpdatedDate
              ,Addr.Myorder
              ,[STREET1]
              ,[STREET2]
              ,[CITY]
              ,[STATE]
              ,[ZIP]
              ,[COUNTRY]
              ,NULL AS PhoneNumber
              ,NULL as MobileNumber
              ,NULL as EMAIL
          FROM Addr
       UNION
       SELECT Phone.UpdatedDate
              ,Phone.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,PhoneNumber
              ,NULL as MobileNumber
              ,NULL as EMAIL
          FROM Phone
       UNION
       SELECT Mobile.UpdatedDate
              ,Mobile.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL AS PhoneNumber
              ,MobileNumber
              ,NULL as EMAIL
          FROM Mobile        
        UNION
        SELECT Email.UpdatedDate
              ,Email.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL AS PhoneNumber
              ,NULL AS MobileNumber
              ,Email.EMAIL
          FROM Email          
          ORDER BY UpdatedDate DESC, MyOrder ASC;
          
          
    OPEN MyCursor;
    
    FETCH NEXT FROM MyCursor  -- priming read
     INTO @UpdatedDate
          ,@MyOrder   
          ,@Street1   
          ,@Street2   
          ,@City      
          ,@State     
          ,@Zip       
          ,@Country   
          ,@PhoneNumber
          ,@MobileNumber
          ,@Email;       
    
    SET @UpdatedDateOut = @UpdatedDate;          
     
    WHILE @@FETCH_STATUS = 0 -- Not End of file
      BEGIN
        -- If new date, or nowhere to put data value, Insert into temp and clear Output variables
        IF (@UpdatedDate != @UpdatedDateOut AND @RowCount > 0)
        OR (@MyOrder = 1 AND @Street1Out IS NOT NULL)
        OR (@MyOrder = 2 AND @PhoneNumberOut IS NOT NULL)
        OR (@MyOrder = 3 AND @MobileNumberOut IS NOT NULL)
        OR (@MyOrder = 4 AND @EmailOut IS NOT NULL)
        BEGIN
         INSERT INTO @Results (UpdatedDate
                             ,[STREET1]
                             ,[STREET2]
                             ,[CITY]        
                             ,[STATE]         
                             ,[ZIP]          
                             ,[COUNTRY]        
                             ,PhoneNumber     
                             ,MobileNumber    
                             ,EMAIL  )
                      VALUES(@UpdatedDateOut
                            ,@Street1Out
                            ,@Street2Out
                            ,@CityOut
                            ,@StateOut
                            ,@ZipOut
                            ,@CountryOut
                            ,@PhoneNumberOut
                            ,@MobileNumberOut
                            ,@EmailOut);
                            
         SET @UpdatedDateOut = @UpdatedDate;
         SET @Street1Out = NULL;
         SET @Street2Out = NULL;
         SET @CityOut = NULL;
         SET @StateOut = NULL;
         SET @ZipOut = NULL;
         SET @CountryOut = NULL;
         SET @PhoneNumberOut = NULL;
         SET @MobileNumberOut = NULL;
         SET @EmailOut = NULL;                           
        END
        
        SET @RowCount = @RowCount + 1;
        
        -- Set Address Fields
        IF @MyOrder = 1
           BEGIN
             SET @Street1Out = @Street1;
             SET @Street2Out = @Street2;
             SET @CityOut = @City;
             SET @StateOut = @State;
             SET @ZipOut = @Zip;
             SET @CountryOut = @Country;
           END;
                      
        -- Set Phone Number
        IF @MyOrder = 2   
           SET @PhoneNumberOut = @PhoneNumber;
           
        IF @MyOrder = 3
           SET @MobileNumberOut = @MobileNumber;
           
        IF @MyOrder = 4
           SET @EmailOut = @Email;        
      
        FETCH NEXT FROM MyCursor
         INTO @UpdatedDate
              ,@MyOrder   
              ,@Street1   
              ,@Street2   
              ,@City      
              ,@State     
              ,@Zip       
              ,@Country   
              ,@PhoneNumber
              ,@MobileNumber
              ,@Email;       
          
      END;  -- End of loop   
      
      --write last record
     INSERT INTO @Results (UpdatedDate
                   ,[STREET1]
                   ,[STREET2]
                   ,[CITY]        
                   ,[STATE]         
                   ,[ZIP]          
                   ,[COUNTRY]        
                   ,PhoneNumber     
                   ,MobileNumber    
                   ,EMAIL  )
            VALUES(@UpdatedDateOut
                  ,@Street1Out
                  ,@Street2Out
                  ,@CityOut
                  ,@StateOut
                  ,@ZipOut
                  ,@CountryOut
                  ,@PhoneNumberOut
                  ,@MobileNumberOut
                  ,@EmailOut);
    CLOSE MyCursor;
    
    SELECT UpdatedDate
          ,ISNULL(STREET1,'') AS Street1 
          ,ISNULL(STREET2,'') AS Street2
          ,ISNULL(CITY,'') AS City
          ,ISNULL(STATE,'') AS State
          ,ISNULL(ZIP,'') AS Zip
          ,ISNULL(COUNTRY,'') AS Country
          ,ISNULL(PhoneNumber,'') AS PhoneNumber
          ,ISNULL(MobileNumber,'') AS MobileNumber
          ,ISNULL(EMAIL,'') AS Email        
      FROM @Results
  ORDER BY UpdatedDate DESC;    
  
  END 
  
  -- EXECUTE [AHOBPR].[SP_ReportContactHistory] 5
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportStatusByLocation]...';


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Status by Location Report

-- Modification log
-- 20150114 - Sherry Wang: Changed query for @InstitutionId and @VisnId
-- 20150202 - Change state to use state codes, removed unneeded tables and joins, Removed Distinct
-- 20150219 - Change state to include territories and Military Bases
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150722 - Bruce Clegg - Fix bug with @EvaluatedLocationType = 'Base'
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportStatusByLocation]
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL 
       @status varchar(1000) = NULL, -- Multiple statues, comma-separated values when not NULL        
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL  -- 'V16', 'V01'    1000109,  1000089
AS
BEGIN
  DECLARE @Today DATETIME2 = GETDATE();
  
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);
 
 --Temp table concatnate flags for Registrants with multiple flags
CREATE TABLE #state
(
   [Registrant_Id] INT,
   [state] VARCHAR(8000)
) 

SET @state = REPLACE(@state, 'Foreign Country/Other', 'FM,MH,PW,UM,US,CANAD,MX,EU,PI,FG,OT,UN')

INSERT INTO #state ([Registrant_Id], [state])
-- Load Table
 SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
        FROM AHOBPR.REGISTRANT_ADDRESS b 
       WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
              FOR XML PATH('')), 1, 1, '')  [STATE]
        FROM AHOBPR.REGISTRANT a
    GROUP BY a.REGISTRANT_ID
    ORDER BY a.REGISTRANT_ID;
 
	SELECT  reg.REGISTRANT_ID
		     ,(reg.LAST_NAME + ', ' + reg.FIRST_NAME) AS Name
		     ,b.REGISTRANT_STATUS AS Status
		     ,DATEDIFF(day, reg.REGISTRANT_STATUS_LAST_UPDATED_DATE, @Today) As Days
		     ,s.STATE AS State
		     ,RIGHT(inst.VisnID, 2)  AS VISN
		     ,inst.Name AS Facility
		     ,reg.BIRTH_DATE AS BirthDate
         ,CONVERT(VARCHAR(10), reg.BIRTH_DATE, 101) AS BirthDateDisplay
	  FROM AHOBPR.REGISTRANT reg
		JOIN AHOBPR.STD_REGISTRANT_STATUS b 
		  ON reg.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID
	  LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst
		  ON inst.ID = reg.STD_INSTITUTION_ID
		LEFT JOIN #state s
		  ON reg.REGISTRANT_ID = s.Registrant_Id
	 WHERE (ISNULL(@state,'') = ''
	       OR EXISTS(SELECT DISTINCT addr.REGISTRANT_ID 
	                   FROM AHOBPR.REGISTRANT_ADDRESS addr 
	                  WHERE addr.REGISTRANT_ID = reg.REGISTRANT_ID 
	                    AND addr.STATE  IN (SELECT * FROM fncSplit(@state, ','))))
	 	 AND (ISNULL(@status,'') = '' 
	 	     OR reg.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ',')))
     AND (@AssignedLocationType IS NULL
          OR (@AssignedLocationType = 'NLA' 
              AND reg.STD_INSTITUTION_ID IS NULL)
          OR (@AssignedLocationType = 'VISN' 
               AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst
                                  WHERE inst.ID = reg.STD_INSTITUTION_ID
                                    AND inst.VisnID = @AssignedLocationKey)
             )	
          OR (@AssignedLocationType = 'Base' 
               AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst
                                  WHERE inst.ID = reg.STD_INSTITUTION_ID
                                    AND inst.BASE_ID = @AssignedInstitutionId)
             )	
          OR (@AssignedLocationType = 'Institution' 
               AND reg.STD_INSTITUTION_ID = @AssignedInstitutionId)	
          )
     AND (@EvaluatedLocationType IS NULL
          OR (@EvaluatedLocationType = 'NLA' 
              AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval
                               WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID
                                 AND eval.EVALUATION_FLAG = 'Y' ) 
             )
          OR (@EvaluatedLocationType = 'VISN' 
               AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval
                                   JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID
                                  WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID
                                    AND inst.VisnID = @EvaluatedLocationKey
                                    AND eval.EVALUATION_FLAG = 'Y' ) 
             )	
          OR (@EvaluatedLocationType = 'Base' 
               AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval
                                   JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID
                                  WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID
                                    AND inst.BASE_ID = @EvaluatedInstitutionId
                                    AND eval.EVALUATION_FLAG = 'Y' ) 
             )	
          OR (@EvaluatedLocationType = 'Institution' 
               AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval
                                  WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID
                                    AND eval.EVALUATION_FLAG = 'Y' 
                                    AND eval.STD_INSTITUTION_ID = @EvaluatedInstitutionId) 
             )	
          ); 

  DROP TABLE #state
END

-- EXEC [AHOBPR].[SP_ReportStatusByLocation] 
-- EXEC [AHOBPR].[SP_ReportStatusByLocation] @state = 'AA,Foreign Country/Other'
-- EXEC [AHOBPR].[SP_ReportStatusByLocation] @status = 7

-- exec [AHOBPR].[SP_ReportStatusByLocation]
-- exec [AHOBPR].[SP_ReportStatusByLocation] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportStatusByLocation]
-- exec [AHOBPR].[SP_ReportStatusByLocation] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'
GO
PRINT N'Creating [AHOBPR].[SP_ReportRegistrantContact]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 12, 2015
-- Description:	Used for the AHOBPR Contact Report  -- exec [AHOBPR].[SP_ReportRegistrantContact]    (More options at bottom)
-- 2015-02-23 - Clegg - provide individual field names
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150429 - Bruce Clegg - Added Email column (again)
-- 20150617 - D. Barr - Added state parameter
-- 20150722 - Bruce Clegg - Fix bug with @EvaluatedLocationType = 'Base'
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantContact]
       @RegistrantStatus      VARCHAR(50) = '',    -- '1,2,3,4,5,6,7,8'
       @SvcStatus             VARCHAR(50) = '',    -- '1,2,3'
       @AdminFlagId           INT = 0,             -- 60
       @AdminFromDateText     VARCHAR(50) = NULL,
       @AdminToDateText       VARCHAR(50) = NULL,
       @SubPopulationFlagId   INT = 0,             -- 65
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @CompletedFromDateText VARCHAR(50) = NULL,
       @CompletedToDateText   VARCHAR(50) = NULL,
       @state varchar(8000) = NULL -- Multiple states, comma-separated values when not NULL 
AS
BEGIN

DECLARE @AdminFromDate DATETIME2(0) = ISNULL(dbo.CleanDate(@AdminFromDateText),'19000101')
DECLARE @AdminToDate   DATETIME2(0) = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@AdminToDateText),GETDATE())); 
DECLARE @CompletedFromDate DATETIME2(0) = ISNULL(dbo.CleanDate(@CompletedFromDateText),'19000101')
DECLARE @CompletedToDate   DATETIME2(0) = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@CompletedToDateText),GETDATE())); 

PRINT @AssignedLocationType;
PRINT @AssignedLocationKey;

DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

WITH addr 
AS (     
    SELECT REGISTRANT_ID,
		       ISNULL(STREET1,'')  AS STREET1, 
		       ISNULL(STREET2,'')  AS STREET2,
		       ISNULL(CITY,'')     AS CITY,
		       ISNULL([STATE],'')  AS [STATE],
		       ISNULL(COUNTRY,'')  AS COUNTRY,
		       ISNULL(ZIP,'')      AS ZIP
		  FROM  AHOBPR.[REGISTRANT_ADDRESS]
    )  
,phone1 
AS (     
    SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') AS PHONE_NUMBER_Main
      FROM AHOBPR.REGISTRANT_PHONE	
     WHERE ISNULL(TYPE,'Main') = 'Main'
    )       
,phone2 
AS (     
    SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') AS PHONE_NUMBER_Mobile
      FROM AHOBPR.REGISTRANT_PHONE	
     WHERE TYPE = 'Mobile'
    )
,email 
AS (     
    SELECT REGISTRANT_ID,		     
		       ISNULL(EMAIL,'') AS EMAIL
      FROM AHOBPR.REGISTRANT_EMAIL	
    )
,Pref    
AS(
      SELECT fr.REGISTRANT_ID 
           ,ans.TEXT AS ContactPreference
        FROM  AHOBPR.FORM_RESPONSE fr
        JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
        JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
        JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
        JOIN AHOBPR.STD_FORM_ANSWER ans ON ans.STD_FORM_ANSWER_ID = rAns.STD_FORM_ANSWER_ID
       WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
         AND qst.FORM_QUESTION_UNIQUE_ID = '8.A'
 )           
  	SELECT 
  	      reg.REGISTRANT_ID,
		      ISNULL(reg.LAST_NAME,'') AS  LAST_NAME,
          ISNULL(reg.FIRST_NAME,'') AS  FIRST_NAME, 
          ISNULL(Pref.ContactPreference,'') AS  ContactPreference,
		      ISNULL(STREET1,'') AS  STREET1, 
		      ISNULL(STREET2,'') AS  STREET2,
		      ISNULL(CITY,'') AS  CITY,
		      ISNULL([STATE],'') AS  [STATE],
		      ISNULL(COUNTRY,'') AS  COUNTRY,
		      ISNULL(ZIP,'') AS  ZIP,
		      ISNULL(phone1.PHONE_NUMBER_Main,'') AS  PHONE_NUMBER_Main,
		      ISNULL(phone2.PHONE_NUMBER_Mobile,'') AS  PHONE_NUMBER_Mobile,
          ISNULL(email.EMAIL,'') AS EMAIL	
	  FROM AHOBPR.REGISTRANT reg	
	  LEFT JOIN addr  
		  ON reg.REGISTRANT_ID = addr.REGISTRANT_ID	 
	  LEFT JOIN phone1  
		  ON reg.REGISTRANT_ID = phone1.REGISTRANT_ID	 		  
	  LEFT JOIN phone2  
		  ON reg.REGISTRANT_ID = phone2.REGISTRANT_ID	 	
	  LEFT JOIN email  
		  ON reg.REGISTRANT_ID = email.REGISTRANT_ID	 	      		
	  LEFT JOIN Pref  
		  ON reg.REGISTRANT_ID = Pref.REGISTRANT_ID	 				
 	 WHERE (reg.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@RegistrantStatus, ',')) 
	        OR ISNULL(@RegistrantStatus,'') = '')
	   AND (reg.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@SvcStatus, ',')) 
	        OR ISNULL(@SvcStatus,'') = '')
     AND (@AssignedLocationType IS NULL
          OR (@AssignedLocationType = 'NLA' 
              AND reg.STD_INSTITUTION_ID IS NULL)
          OR (@AssignedLocationType = 'VISN' 
               AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst
                                  WHERE inst.ID = reg.STD_INSTITUTION_ID
                                    AND inst.VisnID = @AssignedLocationKey)
             )	
          OR (@AssignedLocationType = 'Base' 
               AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst
                                  WHERE inst.ID = reg.STD_INSTITUTION_ID
                                    AND inst.BASE_ID = @AssignedInstitutionId)
             )	
          OR (@AssignedLocationType = 'Institution' 
               AND reg.STD_INSTITUTION_ID = @AssignedInstitutionId)	
          )
     AND (@EvaluatedLocationType IS NULL
          OR (@EvaluatedLocationType = 'NLA' 
              AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval
                               WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID 
                                 AND eval.EVALUATION_FLAG = 'Y') 
             )
          OR (@EvaluatedLocationType = 'VISN' 
               AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval
                                   JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID
                                  WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID
                                    AND inst.VisnID = @EvaluatedLocationKey
                                    AND eval.EVALUATION_FLAG = 'Y') 
             )	
          OR (@EvaluatedLocationType = 'Base' 
               AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval
                                   JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID
                                  WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID
                                    AND inst.BASE_ID = @EvaluatedInstitutionId
                                    AND eval.EVALUATION_FLAG = 'Y' ) 	
             )	
          OR (@EvaluatedLocationType = 'Institution' 
               AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval
                                  WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID
                                    AND eval.STD_INSTITUTION_ID = @EvaluatedInstitutionId
                                    AND eval.EVALUATION_FLAG = 'Y') 
             )	
          )          
     AND (ISNULL(@SubPopulationFlagId, 0) = 0 
          OR EXISTS(SELECT [REGISTRANT_ID] FROM AHOBPR.REGISTRANT_REGISTRY_FLAG popFlag
                     WHERE popFlag.REGISTRANT_ID = reg.REGISTRANT_ID
                       AND popFlag.STD_REGISTRY_FLAG_ID = @SubPopulationFlagId))
     AND (ISNULL(@AdminFlagId, 0) = 0 
          OR EXISTS(SELECT [REGISTRANT_ID] FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminFlag
                     WHERE adminFlag.REGISTRANT_ID = reg.REGISTRANT_ID
                       AND adminFlag.STD_REGISTRY_FLAG_ID = @AdminFlagId
                       AND adminFlag.CREATED BETWEEN @AdminFromDate AND @AdminToDate))   
     AND ((ISNULL(@CompletedFromDateText,'') = '' AND ISNULL(@CompletedToDateText,'') = '' )
         OR EXISTS(SELECT resp.REGISTRANT_ID, stat.QUESTIONNAIRE_COMPLETED_DATE
                     FROM AHOBPR.FORM_RESPONSE_STATUS stat
                     JOIN AHOBPR.FORM_RESPONSE resp
                       ON resp.FORM_RESPONSE_ID = stat.FORM_RESPONSE_ID
                    WHERE resp.REGISTRANT_ID = reg.REGISTRANT_ID
                      AND stat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @CompletedFromDate AND @CompletedToDate))
    AND (ISNULL(@state,'') = ''
	       OR EXISTS(SELECT DISTINCT addr.REGISTRANT_ID 
	                   FROM AHOBPR.REGISTRANT_ADDRESS addr 
	                  WHERE addr.REGISTRANT_ID = reg.REGISTRANT_ID 
	                    AND addr.STATE  IN (SELECT * FROM fncSplit(@state, ','))))
      ;
                                                                                                             
END
-- exec [AHOBPR].[SP_ReportRegistrantContact]
-- exec [AHOBPR].[SP_ReportRegistrantContact] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantContact]
-- exec [AHOBPR].[SP_ReportRegistrantContact] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'


       --@AssignedLocationType  VARCHAR(10) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       --@AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
 --exec [AHOBPR].[SP_ReportRegistrantContact] '5,6,7', NULL, 0, NULL, NULL, 0, 0, NULL  @EvaluatedLocationType
 --exec [AHOBPR].[SP_ReportRegistrantContact] NULL, '2', 0, NULL, NULL, 0, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantContact] NULL, NULL, 60, NULL, '20141204', 0, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantContact] NULL, NULL, 60, '12/04/2014', NULL, 0, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantContact] NULL, NULL, 60, '12/03/2014', '12/12/2014', 0, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantContact] NULL, NULL, 0, NULL, NULL, 65, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantContact] NULL, NULL, 0, NULL, NULL, 0, 1000109, NULL
 --exec [AHOBPR].[SP_ReportRegistrantContact] NULL, NULL, 0, NULL, NULL, 0, 0, 'NLA' --'V01'
 --exec [AHOBPR].[SP_ReportRegistrantContact] @CompletedFromDateText = '08/13/2014'
 --exec [AHOBPR].[SP_ReportRegistrantContact] @CompletedToDateText = '08/13/2014'
 --exec [AHOBPR].[SP_ReportRegistrantContact] @CompletedFromDateText = '08/13/2014', @CompletedToDateText = '08/13/2014'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportAdHocByLocation]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters, Add distinct and outer query to group counts.
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-05-07 - Bruce Clegg - Change Facility name from "Other" to "No Facitilty Assigned" when not found
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce Clegg - Rewrote as Dynamic SQL for performance
-- 2015-08-05 - Bruce Clegg - Fix bug with AdminFlag - Set From and To date defaults
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByLocation]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(10) = 'All', 
       @requestToBeSeen varchar(10) = 'All',
       @groupBy VARCHAR(50) = '',                 -- 'VISN' or 'Facility'   
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = ''
AS

BEGIN

  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL;
          
  DECLARE @Query VARCHAR(8000);      

  -- Convert date parameters      

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));   

  -- Build Src TDE
  SET @Query = ' WITH Src 
    AS( SELECT a.REGISTRANT_ID, a.STD_INSTITUTION_ID FROM AHOBPR.REGISTRANT a WHERE 1 = 1 ';
  
  IF @status IS NOT NULL
    SET @Query = @Query + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @Query = @Query + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @Query = @Query + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @Query = @Query + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
    
  IF @formStartFromDate IS NOT NULL OR @formStartToDate IS NOT NULL 
  OR @formCompletionFromDate IS NOT NULL OR @formCompletionToDate IS NOT NULL
    BEGIN
      SET @Query = @Query + ' AND EXISTS( SELECT d.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE d 
		                        JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID	
		                       WHERE a.REGISTRANT_ID = d.REGISTRANT_ID ';
		  IF @formStartFromDate IS NOT NULL                     
		     SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
		  IF @formStartToDate IS NOT NULL                     
		     SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
		  IF @formCompletionFromDate IS NOT NULL                     
		     SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';
		  IF @formCompletionToDate IS NOT NULL                     
		     SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
		   SET @Query = @Query + ' ) ' -- Close Exisits statement
    END    
    
  IF ISNULL(@answer,'') != '' 
    SET @Query = @Query + ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' +
                          'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID ' +
                          'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID ' +
                        ' WHERE ra.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';
  
  IF ISNULL(@subpopulationFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                            
  IF ISNULL(@healthFactor,'') != ''
    SET @Query = @Query + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

  IF ISNULL(@deploymentAll,'') != '' 
    SET @Query = @Query + ' AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                       ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                           AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;

  IF ISNULL(@deploymentExposure,'') != '' 
    SET @Query = @Query + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID = ''1.2.A'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @Query = @Query + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @Query = @Query + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @Query = @Query + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @Query = @Query + ' AND ''' + @separationType + ''' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @Query = @Query + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @Query = @Query + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @Query = @Query + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @Query = @Query + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  -- Add Summary TDE                   
  SET @Query = @Query + '  )	,Summary  AS( ' + 
                        ' SELECT Src.STD_INSTITUTION_ID, COUNT(*) AS TotalRegistrants FROM Src ' +
                        ' GROUP BY STD_INSTITUTION_ID ) ';
-- By Facility 
	IF @groupBy = 'Facility'
	  SET @Query = @Query + ' SELECT inst.Name AS Location, ' +
	                                ' ISNULL(CONVERT(VARCHAR(10),Summary.STD_INSTITUTION_ID),''-1'') AS LocationId, ' +
                                   '  SUM(TotalRegistrants) AS TotalRegistrants FROM Summary ' +		       
	                         '  JOIN AHOBPR.VIEW_INSTITUTION_NAME inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1) ' +
	                         ' GROUP BY inst.Name,STD_INSTITUTION_ID ' +
  		                     ' OPTION (OPTIMIZE FOR UNKNOWN);';
  
-- By VISN
	IF @groupBy = 'VISN'
	   SET @Query = @Query + ' ,VisnSummary AS ( ' +
                 ' SELECT ISNULL(inst.VisnID,''NLA'') AS Location, ' +
                       '  ISNULL(inst.VisnID, ''-1'') AS LocationId, ' +
                       '  SUM(TotalRegistrants) AS TotalRegistrants ' +		       
                 '   FROM Summary ' +   
                 '   LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1) ' +  
                 '   GROUP BY inst.VisnID  ) ' +
                 ' SELECT REPLACE(Location,''NLA'',''No Facitilty Assigned'') AS Location, ' +
                 '        CONVERT(VARCHAR(10),LocationId) AS LocationId, TotalRegistrants ' +
                 '   FROM VisnSummary  ' +
                 '  ORDER BY Location ' + 
                 '  OPTION (OPTIMIZE FOR UNKNOWN); ' ;
	
  PRINT @Query;		
  		                     
  EXECUTE (@Query);  		                     		
END
-- Parameters
  --@status, @dutyStatus ,@questionnaireStartDate, @questionnaireCompleteDate, 
  --@questionNumber, @answer, @healthConcerns= 'All', @requestToBeSeen = 'All',
  --@registryFlag,@InstitutionId = 0, @VisnId = '' 
-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @status = '6,7'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthConcerns = 'Yes' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @requestToBeSeen = 'Yes'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentAll = 'Iraq'    -- 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @questionNumber = '1.2.E'  , @answer = '2346,1571,17'  
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy =  'Facility' , @status = '6,7' ,@answer = '2346,1571,17'   -- '20,795,1570' 
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_LoadDodDeploymentInsert]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 2015-08-07
-- Description:	Move data from Staged table, creating orphans and massaging data

-- Modification log
CREATE PROCEDURE [AHOBPR].[SP_LoadDodDeploymentInsert]
AS
BEGIN

  PRINT 'Truncate DoD Depoyment...';
  
  TRUNCATE TABLE [AHOBPR].[DOD_DEPLOYMENT_IMPORT];

  PRINT 'Add Orphan Country codes if needed...';

  WITH Staged
  AS( 
      SELECT DISTINCT LOCATION
        FROM AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT
     )
     INSERT INTO [AHOBPR].[STD_COUNTRY]
             ([CODE]
             ,[DESCRIPTION])
     SELECT LOCATION,
            LOCATION + ' - Orphan'
       FROM Staged
  WHERE NOT EXISTS(SELECT [CODE]
                     FROM [AHOBPR].[STD_COUNTRY]
                     WHERE [CODE] = LOCATION);
                     
  PRINT 'Add Orphan Pay Grade codes if needed...';

  WITH Staged
  AS( 
      SELECT DISTINCT GRADE
        FROM AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT
     )
     INSERT INTO AHOBPR.STD_PAY_PLAN_GRADE
             ([CODE]
             ,[DESCRIPTION])
     SELECT GRADE,
            GRADE + ' - Orphan'
       FROM Staged
  WHERE NOT EXISTS(SELECT [CODE]
                     FROM AHOBPR.STD_PAY_PLAN_GRADE
                     WHERE [CODE] = GRADE);

  PRINT 'Set Service Name values...';

  WITH MasterData
  AS (
      SELECT *
        FROM ( VALUES
        ('A','Army'),
        ('C','Coast Guard'),
        ('F','Air Force'),
        ('M','Marine Corps'),
        ('N','Navy')
              ) Record(Code, ServiceName)
       )
  ,Src 
  AS (
  SELECT Staged.DEPLOYMENT_ID, ServiceName
    FROM MasterData
    JOIN AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Staged
      ON Staged.SVC = MasterData.Code
      )
  MERGE INTO AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Tgt
  USING Src
     ON Tgt.DEPLOYMENT_ID = Src.DEPLOYMENT_ID
  WHEN MATCHED
  THEN UPDATE
          SET Tgt.[Service] = Src.ServiceName;

  PRINT 'Set Component Name values...';

  WITH MasterData
  AS (
      SELECT *
        FROM ( VALUES
        ('R','Regular'),
        ('V','Reserve'),
        ('G','Guard')
              ) Record(Code, CompoName)
       )
  ,Src 
  AS (
  SELECT Staged.DEPLOYMENT_ID, CompoName
    FROM MasterData
    JOIN AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Staged
      ON Staged.COMPO = MasterData.Code
      )
  MERGE INTO AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Tgt
  USING Src
     ON Tgt.DEPLOYMENT_ID = Src.DEPLOYMENT_ID
  WHEN MATCHED
  THEN UPDATE
          SET Tgt.[Component] = Src.CompoName;

  PRINT 'Load from Statged into DOD Deployment..';
                     
  DECLARE @Now DATETIME2(0) = GETDATE();
  DECLARE @DefaultStart DATETIME2(0) = '20010101';

  INSERT INTO [AHOBPR].[DOD_DEPLOYMENT_IMPORT]
             ([EDIPI]
             ,[SERVICE]
             ,[COMPO]
             ,[LOCATION]
             ,[DEPLOYMENT_START_DATE]
             ,[DEPLOYMENT_END_DATE]
             ,[LOCATION_START_DATE]
             ,[LOCATION_END_DATE]
             ,[PAY_PLAN_GRADE]
             ,[IMPORT_DATE])
  SELECT [EDIPI]
        ,ISNULL(SUBSTRING([Service],1,15),SVC)
        ,ISNULL(SUBSTRING([Component],1,10),COMPO)
        ,[LOCATION]
        ,ISNULL([DEP_BGN_CDT], @DefaultStart)
        ,ISNULL([DEP_END_CDT], @Now)
        ,ISNULL([LOC_BEGIN_DATE], @DefaultStart)
        ,ISNULL([LOC_END_DATE], @Now)
        ,[GRADE]
        ,@Now
        --,[PN_SEX_CD] -- New fields to be added next release
        --,[MRTL_STAT_CD]
        --,[EDU_LVL_CD]
        --,[RACE_CD]
        --,[ETH_AFF_CD]
        --,[DTY_DOD_OCC_CD]
    FROM [AHOBPR].[STAGED_DOD_DEPLOYMENT_IMPORT];
    
END;
    -- EXECUTE  [AHOBPR].[SP_LoadDodDeploymentInsert]    -- about 8 minutes
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportClinicallyRevelantSummary]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
--      Author:		Bruce Clegg
-- Create date: February 4, 2015
-- Description:	Used for the AHOBPR Clinically Revelant Summary
--        Note: Data is massaged for questions 1.2.A, 1.2.F, 1.2.G, 2.5.A and 2.5.C 
-- Modification log
-- 20150427 - Clegg - get deployment counts independent of Question numbers
-- 20150811 - Clegg - remove testing value
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportClinicallyRevelantSummary]
       @RegistrantId INT = 0         
AS
BEGIN

   --Temp table concatenate Answers for Questions
  CREATE TABLE #Answers
  (
     QuestionNumber VARCHAR(100),
     QuestionNumberDisplay VARCHAR(100),
     AnswerValues VARCHAR(8000)
  ); 


  -- Load all clinical relevent answers that are NOT from a Deployment
  WITH Responses
  AS (SELECT qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumber,
	           ISNULL(rAns.ANSWER_VALUE,ans.[TEXT])  AS AnswerValue
	      FROM AHOBPR.REGISTRANT reg
	      JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
	      JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
	      JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
	      JOIN AHOBPR.STD_FORM_ANSWER ans ON rAns.STD_FORM_ANSWER_ID = ans.STD_FORM_ANSWER_ID
	      JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
	     WHERE fr.STD_FORM_ID = ans.STD_FORM_ID
	       AND qst.STD_FORM_ID = fr.STD_FORM_ID
	       AND ans.CLINICAL_RELEVANT_FLAG = 1
	       AND reg.REGISTRANT_ID = @RegistrantId
	       AND rQst.REGISTRANT_DEPLOYMENT_ID IS NULL
  )

  INSERT INTO #Answers (QuestionNumber, QuestionNumberDisplay, AnswerValues)
   SELECT a.QuestionNumber, a.QuestionNumber,
          STUFF((SELECT '~' + b.AnswerValue 
          FROM Responses b 
         WHERE a.QuestionNumber = b.QuestionNumber 
                FOR XML PATH('')), 1, 1, '')  AnswerValues
          FROM Responses a
      GROUP BY a.QuestionNumber
      ORDER BY a.QuestionNumber;
      
      
  -- Get Deployment Count without limiting it to a specific Question.
     DECLARE @DeploymentCount INT = 0;
     With Deployments 
     AS(   
         SELECT DISTINCT rQst.REGISTRANT_DEPLOYMENT_ID
           FROM AHOBPR.REGISTRANT reg
           JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
           JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
          WHERE reg.REGISTRANT_ID = @RegistrantId 
            AND rQst.REGISTRANT_DEPLOYMENT_ID IS NOT NULL
        )
     SELECT @DeploymentCount =  COUNT(REGISTRANT_DEPLOYMENT_ID) 
       FROM Deployments;  
     
  -- Load specific clinical relevent answers summarized for all Deployments - '1.2.A','1.2.F' 
  INSERT INTO #Answers (QuestionNumber, QuestionNumberDisplay, AnswerValues)
       SELECT qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumber
             ,qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumberDisplay
	           ,'Said yes to '+ CONVERT(VARCHAR(2),SUM(CASE WHEN ISNULL(rAns.ANSWER_VALUE,ans.[TEXT]) = 'Yes' THEN 1 ELSE 0 END)) 
	           + ' of ' + CONVERT(VARCHAR(2),@DeploymentCount) + ' deployments' AS AnswerValues
          FROM AHOBPR.REGISTRANT reg
          JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
          JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
          LEFT JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
          LEFT JOIN AHOBPR.STD_FORM_ANSWER ans ON rAns.STD_FORM_ANSWER_ID = ans.STD_FORM_ANSWER_ID
          JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
         WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
           AND reg.REGISTRANT_ID = @RegistrantId
           AND qst.FORM_QUESTION_UNIQUE_ID in ('1.2.A','1.2.F')
           GROUP BY qst.FORM_QUESTION_UNIQUE_ID; 
  
    -- Always Delete any zero counts from above that were created in order to capture true Deployment count.          
  DELETE FROM #Answers WHERE AnswerValues LIKE 'Said yes to 0 of % deployments'
                          AND QuestionNumber in ('1.2.A','1.2.F');
  
    
  -- Load specific clinical relevent answers summarized for all Deployments -- '1.2.G'
  INSERT INTO #Answers (QuestionNumber, QuestionNumberDisplay, AnswerValues)
      SELECT qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumber
           ,qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumberDisplay
	         ,'Maximum: '+ CONVERT(VARCHAR(2),MAX(CONVERT(INT,rAns.ANSWER_VALUE))) 
	         + ' hours, Average: '+ LEFT(CONVERT(VARCHAR(20),AVG(CONVERT(DECIMAL(6,2),rAns.ANSWER_VALUE))),4)
	         + ' hours, Deployments: ' + CONVERT(VARCHAR(2),@DeploymentCount) AS AnswerValues
        FROM AHOBPR.REGISTRANT reg
        JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
        JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
        JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
       WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
         AND qst.STD_FORM_ID = fr.STD_FORM_ID
         AND reg.REGISTRANT_ID = @RegistrantId
         AND qst.FORM_QUESTION_UNIQUE_ID = '1.2.G'
         GROUP BY qst.FORM_QUESTION_UNIQUE_ID; 
                                   
    -- Always Delete any Null or Empty Answers.          
  DELETE FROM #Answers WHERE ISNULL(AnswerValues,'')  = '';
      

  -- Tobacco Exposure
  -- if both 2.5.A and 2.5.C exist, replace with Combined answer text'  
  DECLARE @25A VARCHAR(200) = (SELECT AnswerValues FROM #Answers WHERE QuestionNumber = '2.5.A')
  DECLARE @25C VARCHAR(200) = (SELECT AnswerValues FROM #Answers WHERE QuestionNumber = '2.5.C')
  IF @25A = 'Yes'
       IF  @25C = 'Not at all'
          UPDATE #Answers SET AnswerValues = 'Past Smoker' 
                             ,QuestionNumberDisplay = '2.5'
                        WHERE QuestionNumber = '2.5.A';
       ELSE
          UPDATE #Answers SET AnswerValues = 'Current Smoker'
                             ,QuestionNumberDisplay = '2.5'
                        WHERE QuestionNumber = '2.5.A';
   IF  @25A = 'No'
       UPDATE #Answers SET AnswerValues = 'Never smoked' 
                             ,QuestionNumberDisplay = '2.5'
                        WHERE QuestionNumber = '2.5.A';

  -- Always Delete 2.5.C, as it cannot stand on it's own         
  DELETE FROM #Answers WHERE QuestionNumber = '2.5.C';     
      
  -- Final Query         
	SELECT DISTINCT 
          list.QuestionNumberDisplay AS QuestionNumber
	       ,CASE WHEN qst.SHORT_TEXT = 'Have you smoked at least 100 cigarettes in your entire life?'  -- 2.5.A
	             THEN 'Have you ever smoked?'
	             ELSE qst.SHORT_TEXT END  AS QuestionText
	       ,REPLACE(list.AnswerValues,'~','<br/>') AS AnswerValues
	       ,sec.STD_FORM_SECTION_ID AS SectionId                    
	       ,sub.STD_FORM_SUB_SECTION_ID AS SubsectionId	              
	       ,CASE WHEN ISNULL(sub.MENU_ITEM_NAME, '') = '' 
	             THEN Convert(VARCHAR, sec.BRP_FORM_SECTION_ID) + ' ' + sec.MENU_ITEM_NAME
	             ELSE Convert(VARCHAR, sec.BRP_FORM_SECTION_ID) + '.' + Convert(VARCHAR, sub.BRP_FORM_SUB_SECTION_ID) + ' ' + sec.MENU_ITEM_NAME + ' > ' + sub.MENU_ITEM_NAME
	             END AS SectionAndSubSection
	  FROM AHOBPR.REGISTRANT reg
	  JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
	  JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
	  JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
	  JOIN #Answers list ON qst.FORM_QUESTION_UNIQUE_ID = list.QuestionNumber 
	  JOIN STD_FORM_SECTION sec ON sec.STD_FORM_SECTION_ID = qst.STD_FORM_SECTION_ID
	  JOIN STD_FORM_SUB_SECTION sub ON sub.STD_FORM_SUB_SECTION_ID = qst.STD_FORM_SUB_SECTION_ID
	 WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
	   AND reg.REGISTRANT_ID = @RegistrantId;
	  	 
  DROP TABLE #Answers
END

-- EXEC [AHOBPR].[SP_ReportClinicallyRevelantSummary] 149
-- 5  6  7  8  108
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_PostMigrationDataUpdates]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE PROCEDURE [AHOBPR].[SP_PostMigrationDataUpdates]
      
AS
BEGIN

  PRINT 'PostMigrationDataUpdates.sql started...';
  PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';

  PRINT 'Step 01 - Set display Question Number...'; 
   
  With GoodValues 
  AS (
  SELECT Q.STD_FORM_QUESTION_ID
        ,CONVERT(VARCHAR(10),sec.BRP_FORM_SECTION_ID) + '.'
        +CONVERT(VARCHAR(10),ss.[BRP_FORM_SUB_SECTION_ID])+ '.'
        +Q.BRP_FORM_QUESTION_ID AS CalculatedID
    FROM AHOBPR.STD_FORM_QUESTION Q 
    JOIN [AHOBPR].[STD_FORM_SUB_SECTION] ss  ON Q.STD_FORM_SUB_SECTION_ID = ss.STD_FORM_SUB_SECTION_ID
    JOIN AHOBPR.STD_FORM_SECTION sec         ON sec.STD_FORM_SECTION_ID = ss.STD_FORM_SECTION_ID 
    )
    MERGE INTO AHOBPR.STD_FORM_QUESTION as Tgt
    USING GoodValues AS Src
       ON tgt.STD_FORM_QUESTION_ID = Src.STD_FORM_QUESTION_ID
     WHEN MATCHED
     THEN  UPDATE
              SET Tgt.FORM_QUESTION_UNIQUE_ID = Src.CalculatedID;
 
  PRINT 'Step 02 - Clear all Clinical Relevant Flag...)';
  
  UPDATE AHOBPR.STD_FORM_ANSWER
    SET CLINICAL_RELEVANT_FLAG = 0;
  
  PRINT 'Step 03 - Setting Clinical Relevant Flag...)';
  
  WITH  MasterData
    AS ( 
          SELECT *
          FROM   ( VALUES
          ('1.2.A','Yes'),
          ('1.2.F','Yes'),
          ('1.2.G',''),
          ('1.3.B',''),
          ('1.4.C',''),
          ('1.4.D','Yes'),
          ('1.4.E',''),
          ('1.4.F','Yes'),
          ('2.1.D','can''t do it at all'),
          ('2.1.D','somewhat difficult'),
          ('2.1.D','very difficult'),
          ('2.1.E','can''t do it at all'),
          ('2.1.E','somewhat difficult'),
          ('2.1.E','very difficult'),
          ('2.1.F','Arthritis/rheumatism'),
          ('2.1.F','Back or neck problem'),
          ('2.1.F','Benign Tumors, Cysts'),
          ('2.1.F','Birth defect'),
          ('2.1.F','Brain injury, (for example, Traumatic Brain Injury/TBI, Intellectual disability)'),
          ('2.1.F','Cancer'),
          ('2.1.F','Circulation problems (including blood clots)'),
          ('2.1.F','Depression/anxiety/emotional problem'),
          ('2.1.F','Diabetes'),
          ('2.1.F','Epilepsy, seizures'),
          ('2.1.F','Fibromyalgia, lupus'),
          ('2.1.F','Fracture, bone/joint injury'),
          ('2.1.F','Hearing problem'),
          ('2.1.F','Heart problem'),
          ('2.1.F','Hernia'),
          ('2.1.F','Hypertension/high blood pressure'),
          ('2.1.F','Kidney, bladder or renal problems'),
          ('2.1.F','Knee problems (not arthritis, not joint injury)'),
          ('2.1.F','Lung/breathing problem (for example, asthma and emphysema)'),
          ('2.1.F','Migraine headaches (not just headaches)'),
          ('2.1.F','Missing limbs (fingers, toes or digits), amputee'),
          ('2.1.F','Multiple Sclerosis (MS), Muscular Dystrophy (MD)'),
          ('2.1.F','Osteoporosis, tendinitis'),
          ('2.1.F','Other developmental problem (for example, cerebral palsy)'),
          ('2.1.F','Other injury'),
          ('2.1.F','Other nerve damage, including carpal tunnel syndrome'),
          ('2.1.F','Parkinson''s disease, other tremors'),
          ('2.1.F','Polio (myelitis), paralysis, para/quadriplegia'),
          ('2.1.F','Senility'),
          ('2.1.F','Stroke problem'),
          ('2.1.F','Thyroid problems, Grave''s disease, gout'),
          ('2.1.F','Ulcer'),
          ('2.1.F','Varicose veins, hemorrhoids'),
          ('2.1.F','Vision/problem seeing'),
          ('2.1.F','Weight problem'),
          ('2.2.1.B','Yes'),
          ('2.2.1.C','Yes'),
          ('2.2.1.D','Yes'),
          ('2.2.1.E','Yes'),
          ('2.2.1.F','Yes'),
          ('2.2.1.G','Yes'),
          ('2.2.1.H','Yes'),
          ('2.2.1.I','After deployment'),
          ('2.2.1.I','Before deployment'),
          ('2.2.1.I','During deployment'),
          ('2.2.1.J','About the same'),
          ('2.2.1.J','Better'),
          ('2.2.1.J','Worse'),
          ('2.2.1.M','Stopping for breath after walking about 100 yards or after a few minutes on level ground'),
          ('2.2.1.M','Too breathless to leave the house, or breathless when dressing or undressing'),
          ('2.2.1.M','Walking slower than most people on level ground, stop after one mile, or stop after 15 minutes walking at my own pace'),
          ('2.4.A','Yes'),
          ('2.4.B','Bladder'),
          ('2.4.B','Blood'),
          ('2.4.B','Bone'),
          ('2.4.B','Brain'),
          ('2.4.B','Breast'),
          ('2.4.B','Cervix'),
          ('2.4.B','Colon'),
          ('2.4.B','Esophagus'),
          ('2.4.B','Gallbladder'),
          ('2.4.B','Kidney'),
          ('2.4.B','Larynx-windpipe'),
          ('2.4.B','Leukemia'),
          ('2.4.B','Liver'),
          ('2.4.B','Lung'),
          ('2.4.B','Lymphoma'),
          ('2.4.B','Melanoma'),
          ('2.4.B','Mouth/tongue/lip'),
          ('2.4.B','Other'),
          ('2.4.B','Ovary'),
          ('2.4.B','Pancreas'),
          ('2.4.B','Prostate'),
          ('2.4.B','Rectum'),
          ('2.4.B','Skin (Don''t Know what kind)'),
          ('2.4.B','Skin (non-melanoma)'),
          ('2.4.B','Soft tissue (muscle or fat)'),
          ('2.4.B','Stomach'),
          ('2.4.B','Testis'),
          ('2.4.B','Throat-pharynx'),
          ('2.4.B','Thyroid'),
          ('2.4.B','Uterus'),
          ('2.5.A','No'),
          ('2.5.A','Yes'),
          ('2.5.C','Don''t know'),
          ('2.5.C','Everyday'),
          ('2.5.C','I do not wish to answer'),
          ('2.5.C','Not at all'),
          ('2.5.C','Some days'),
          ('3.1.A','About the same'),
          ('3.1.A','Better'),
          ('3.1.A','Worse'),
          ('3.1.E','A little concerned'),
          ('3.1.E','Very concerned'),
          ('3.1.F','Cancer'),
          ('3.1.F','Effect on children or ability to have children'),
          ('3.1.F','Eye problem'),
          ('3.1.F','Gastrointestinal (GI) problem'),
          ('3.1.F','Heart problem'),
          ('3.1.F','Immune problem'),
          ('3.1.F','Lung/Respiratory/Breathing problem'),
          ('3.1.F','Neurological problem'),
          ('3.1.F','Other problem'),
          ('3.1.F','Skin problem'),
          ('3.1.H','Yes'),
          ('3.1.J','Cancer'),
          ('3.1.J','Effect on children or ability to have children'),
          ('3.1.J','Eyes'),
          ('3.1.J','Heart'),
          ('3.1.J','Lung/Respiratory/Breathing'),
          ('3.1.J','Other'),
          ('3.1.J','Skin'),
          ('5.4.A','Yes'),
          ('5.4.B.4','Yes'),
          ('5.5.D','Yes')
          )
           AS MasterRecord(QuestionID, AnswerText)
         )
         UPDATE AHOBPR.STD_FORM_ANSWER
         SET CLINICAL_RELEVANT_FLAG = 1
         WHERE STD_FORM_ANSWER_ID IN 
              (       
                SELECT A.STD_FORM_ANSWER_ID           
                  FROM AHOBPR.STD_FORM_ANSWER A
                  JOIN AHOBPR.STD_FORM_QUESTION B 
                    ON A.STD_FORM_QUESTION_ID = B.STD_FORM_QUESTION_ID 
                 WHERE EXISTS(SELECT * FROM MasterData 
                               WHERE B.FORM_QUESTION_UNIQUE_ID = MasterData.QuestionID
                                 AND ISNULL(A.[TEXT],'') = MasterData.AnswerText)
               );  
            
  PRINT 'Step 04 - Loading Tool Tips for Sections...';

  WITH  MasterData
  AS    ( 
          SELECT *
          FROM    ( VALUES       
        (1,'To view questionnaire responses for Deployment History select from the sub sections below.'),
        (2,'To view questionnaire responses to Symptoms & Medical History select from the sub sections below.'),
        (3,'Select to view registrant responses to Health Concerns.'),
        (4,'Select to view registrant responses to Places You''ve Lived.'),
        (5,'To view questionnaire responses to Work History select from the sub sections below.'),
        (6,'Select to view registrant responses to Home Environment & Hobbies.'),
        (7,'Select to view registrant responses to Health Care Utilization.'),
        (8,'Select to view registrant responses to Contact Preferences.')
        )
         AS MasterRecord(id, TextValue)
         )       
  MERGE
    INTO  AHOBPR.STD_FORM_SECTION   AS Tgt
    USING MasterData AS Src
    ON    Tgt.BRP_FORM_SECTION_ID = Src.id
   WHEN MATCHED 
   THEN UPDATE SET Tgt.TOOL_TIP = Src.TextValue;   
 
  PRINT 'Step 05 - Loading Tool Tips for Sub Sections...';
       
  WITH  MasterData
  AS    ( 
          SELECT *
          FROM    ( VALUES       
                    (1,1,'Select to view registrant deployment history received from deployment interfaces.'),
                    (1,2,'Select to view registrant responses for deployment specific questions.'),
                    (1,3,'Select to view registrant responses to Military Occupational Exposures.'),
                    (1,4,'Select to view registrant responses to Environment Exposures & Air Pollution.'),
                    (2,1,'Select to view registrant responses to Functional Limitations & Reported Causes.'),
                    (2,2,'Select to view registrant responses to Health Conditions.'),
                    (2,3,'Select to view registrant responses to Height & Weight.'),
                    (2,4,'Select to view registrant responses to Cancer History.'),
                    (2,5,'Select to view registrant responses to Tobacco Exposure.'),
                    (2,6,'Select to view registrant responses to Deployment Smoking History.'),
                    (2,7,'Select to view registrant responses to Month Alcohol Use.'),
                    (3,1,'Select to view registrant responses to Health Concerns.'),
                    (4,1,'Select to view registrant responses to Places You''ve Lived.'),
                    (5,1,'Select to view registrant responses to Current Occupational Status.'),
                    (5,2,'Select to view registrant responses to Main Occupation.'),
                    (5,3,'Select to view registrant responses to Dust Exposures.'),
                    (5,4,'Select to view registrant responses to Gas, Smoke, Vapors or Fumes Exposure.'),
                    (5,5,'Select to view registrant responses to Asbestos Exposure.'),
                    (6,1,'Select to view registrant responses to Home Environment & Hobbies.'),
                    (7,1,'Select to view registrant responses to Health Care Utilization.'),
                    (8,1,'Select to view registrant responses to Contact Preferences.')
        )
         AS MasterRecord(SectionId, SubSectionId, TextValue)
   )
   ,Src
   AS(     
     SELECT STD_FORM_SUB_SECTION_ID AS ssId, TextValue
       FROM [AHOBPR].[STD_FORM_SUB_SECTION]
       JOIN AHOBPR.STD_FORM_SECTION 
         ON STD_FORM_SECTION.STD_FORM_SECTION_ID = STD_FORM_SUB_SECTION.STD_FORM_SECTION_ID
       JOIN MasterData 
            ON MasterData.SectionId = STD_FORM_SECTION.BRP_FORM_SECTION_ID
            AND MasterData.SubSectionId = STD_FORM_SUB_SECTION.BRP_FORM_SUB_SECTION_ID
   )
  MERGE
    INTO  AHOBPR.STD_FORM_SUB_SECTION   AS Tgt
    USING  Src
    ON    Tgt.STD_FORM_SUB_SECTION_ID = Src.ssId
   WHEN MATCHED 
   THEN UPDATE SET Tgt.TOOL_TIP = Src.TextValue;
       
  PRINT 'Step 06 - Update STD_FORM_SECTION...';
 
  WITH  MasterData
    AS ( 
          SELECT *
          FROM   ( VALUES
					  (1,'Deployment History'),
					  (2,'Symptoms & Medical History'),
					  (3,'Health Concerns'),
					  (4,'Places You''ve Lived'),
					  (5,'Work History'),
					  (6,'Home Environment & Hobbies'),
					  (7,'Health Care Utilization'),
					  (8,'Contact Preferences')			   )
           AS MasterRecord([BRP_FORM_SECTION_ID], [MENU_ITEM_NAME]) 
         )
   , Src 
   AS (
       SELECT sec.STD_FORM_SECTION_ID, 
            MasterData.[BRP_FORM_SECTION_ID], MasterData.[MENU_ITEM_NAME]
       FROM MasterData 
       JOIN AHOBPR.STD_FORM_SECTION sec ON sec.[BRP_FORM_SECTION_ID] = MasterData.[BRP_FORM_SECTION_ID]
       )
       MERGE
    INTO  [AHOBPR].[STD_FORM_SECTION] AS Tgt
    USING  Src
    ON    Tgt.[STD_FORM_SECTION_ID] = Src.[STD_FORM_SECTION_ID]
    WHEN MATCHED 
   THEN UPDATE SET Tgt.[MENU_ITEM_NAME] = Src.[MENU_ITEM_NAME]; 
   
  PRINT 'Step 07 Update [STD_FORM_SUBSECTION]...';  

  WITH  MasterData
    AS ( 
          SELECT *
          FROM   ( VALUES
				  (1,1,'Deployments'),
				  (1,2,'Deployment Exposures'),
				  (1,3,'Military Occupational Exposures'),
				  (1,4,'Environmental Exposures & Air Pollution'),
				  (2,1,'Functional Limitation & Reported Cause'),
				  (2,2,'Health Conditions'),
				  (2,3,'Height & Weight'),
				  (2,4,'Cancer History'),
				  (2,5,'Tobacco Exposure'),
				  (2,6,'Deployment Smoking History'),
				  (2,7,'12 Month Alcohol Use'),
				  (5,1,'Current Occupational Status'),
				  (5,2,'Main Occupation'),
				  (5,3,'Dust Exposures'),
				  (5,4,'Gas, Smoke, Vapors or Fumes Exposure?'),
				  (5,5,'Asbestos Exposure')
			     )
           AS MasterRecord ( [SECTION_ID], [SUB_SECTION_ID], [MENU_ITEM]) 
         ),
  Src AS (
         SELECT ss.STD_FORM_SUB_SECTION_ID, -- [SECTION_ID], [SUB_SECTION_ID], 
                  [MENU_ITEM]
         FROM MasterData
         JOIN AHOBPR.[STD_FORM_SUB_SECTION] ss ON ss.[BRP_FORM_SUB_SECTION_ID] = MasterData.[SUB_SECTION_ID]
         JOIN AHOBPR.[STD_FORM_SECTION] sec ON ss.[STD_FORM_SECTION_ID] = sec.[STD_FORM_SECTION_ID]
         WHERE MasterData.[SECTION_ID] = sec.BRP_FORM_SECTION_ID
       )
    MERGE
    INTO  [AHOBPR].[STD_FORM_SUB_SECTION] AS Tgt
    USING  Src
    ON    Tgt.[STD_FORM_SUB_SECTION_ID] = Src.[STD_FORM_SUB_SECTION_ID]
    WHEN MATCHED 
    THEN UPDATE 
            SET Tgt.[MENU_ITEM_NAME] = Src.[MENU_ITEM];

  PRINT 'Step 08 - Set Short Text = Text with HTML removed.';       
       
  UPDATE [AHOBPR].[STD_FORM_QUESTION]
       SET SHORT_TEXT = REPLACE(REPLACE(REPLACE([TEXT],'<strong>',''),'</strong>',''),'</br>','');

 PRINT 'Step 09 - Update Question Unique ID to short form for sections 1,3,6,7 & 8 - Should be 33 ';       
 
  With ShortValues 
  AS (
  SELECT Q.STD_FORM_QUESTION_ID
        ,CONVERT(VARCHAR(10),sec.BRP_FORM_SECTION_ID) + '.'
        +Q.BRP_FORM_QUESTION_ID AS CalculatedID
   FROM AHOBPR.STD_FORM_QUESTION Q 
    JOIN [AHOBPR].[STD_FORM_SUB_SECTION] ss  ON Q.STD_FORM_SUB_SECTION_ID = ss.STD_FORM_SUB_SECTION_ID
    JOIN AHOBPR.STD_FORM_SECTION sec         ON sec.STD_FORM_SECTION_ID = ss.STD_FORM_SECTION_ID 
    WHERE sec.BRP_FORM_SECTION_ID IN (1,3,6,7,8)
      AND ss.BRP_FORM_SUB_SECTION_ID = 1
    )
    MERGE INTO AHOBPR.STD_FORM_QUESTION as Tgt
    USING ShortValues AS Src
       ON tgt.STD_FORM_QUESTION_ID = Src.STD_FORM_QUESTION_ID
     WHEN MATCHED
     THEN  UPDATE
              SET Tgt.FORM_QUESTION_UNIQUE_ID = Src.CalculatedID;  
              
  PRINT 'ENABLE TRIGGER TRG_REGISTRANT_JSON_INSERT';               
              
  ENABLE TRIGGER TRG_REGISTRANT_JSON_INSERT ON AHOBPR.REGISTRANT_JSON;
  
  PRINT 'DROP INDEX [IX_REGISTRANT_JSON_Object] If it exists..';    
  
  IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_JSON]') AND name = N'IX_REGISTRANT_JSON_Object')
      DROP INDEX [IX_REGISTRANT_JSON_Object] ON [AHOBPR].[REGISTRANT_JSON] WITH ( ONLINE = OFF );

  PRINT 'CREATE INDEX [IX_REGISTRANT_JSON_Object] ....';    

  CREATE NONCLUSTERED INDEX [IX_REGISTRANT_JSON_Object] ON [AHOBPR].[REGISTRANT_JSON] 
  (
	  [OBJECT_TYPE] ASC,
	  [OBJECT_ID] ASC,
	  [REGISTRANT_JSON_ID] ASC
  )WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [AHOBPR];

              

  PRINT '';
  PRINT 'PostMigrationDataUpdates.sql Script End.';
  PRINT '';
  PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';

END;

-- EXECUTE [AHOBPR].[SP_PostMigrationDataUpdates]
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_UpdateFromCDW]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 6/12/2015
-- Description:	Called after loading CDW Staging tables
-- 08/12/2015 - Set Gender to MALE and FEMALE
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_UpdateFromCDW]
AS
BEGIN

  DECLARE @Now DATETIME2(0) = GETDATE();
  DECLARE @ProcName VARCHAR(30) = 'AHOBPR.SP_UpdateFromCDW';

  PRINT 'Set Institution ID in Staged Patient';
  
  WITH Src
  AS(
  SELECT REGISTRANT_ID
	    ,PreferredInstitutionCode
	    ,Inst.ID
    FROM [AHOBPR].[STAGED_PATIENT] Stg
    JOIN AHOBPR.VIEW_INSTITUTION Inst ON Inst.STATIONNUMBER = Stg.PreferredInstitutionCode
    )
    MERGE INTO [AHOBPR].[STAGED_PATIENT] AS Tgt
    USING Src
	   ON Tgt.REGISTRANT_ID = Src.REGISTRANT_ID
    WHEN MATCHED
    THEN UPDATE
		    SET Tgt.STD_INSTITUTION_ID = Src.ID;
  
  PRINT 'Update Registrant from staged patient...';

  WITH Src
  AS (
    SELECT [REGISTRANT_ID]
          ,[GENDER]
          ,[DECEASED]
          ,[DateOfDeath]
          ,[RaceText]
          ,[MaritalStatus]
          ,[EligibilityStatus]
          ,[Eligibility]
          ,[PatientICN]
          ,[EnrollmentStatus]
          ,[PreferredInstitutionCode]
          ,[EnrollmentDate]
          ,[STD_INSTITUTION_ID]
      FROM [AHOBPR].[STAGED_PATIENT]
      )
      MERGE INTO [AHOBPR].[REGISTRANT] AS Tgt
      USING Src
	     ON Tgt.REGISTRANT_ID = Src.REGISTRANT_ID
      WHEN MATCHED
      THEN UPDATE
		      SET Tgt.STD_INSTITUTION_ID = Src.STD_INSTITUTION_ID
 		         ,Tgt.GENDER = CASE Src.GENDER WHEN 'F' THEN 'FEMALE' 
 		                                       WHEN 'M' THEN 'MALE' END    
 		         ,Tgt.MARITAL_STATUS = Src.[MaritalStatus] 
 		         ,Tgt.RACE = Src.[RaceText]  
 		         ,Tgt.DECEASED_FLAG = CONVERT(BIT,(CASE Src.[DECEASED] WHEN 'Y' THEN 1 ELSE 0 END))
 		         ,Tgt.DEATH_DATE = Src.[DateOfDeath]    
 		         ,Tgt.ELIGIBILITY_STATUS = Src.[EligibilityStatus]     		        
 		         ,Tgt.ELIGIBILITY = Src.[Eligibility]    
 		         ,Tgt.ENROLLMENT_STATUS = Src.[EnrollmentStatus]    
 		         ,Tgt.ENROLLED_DATE = Src.[EnrollmentDate]       
 		         ,Tgt.ETL_UPDATED = @Now;
  		    
  PRINT 'Delete health factors for encounters being updated';
  DELETE 
  FROM AHOBPR.REGISTRANT_HEALTH_FACTOR
  WHERE EXISTS(SELECT REGISTRANT_VISIT_ID 
                 FROM AHOBPR.REGISTRANT_VISIT
                 JOIN AHOBPR.STAGED_VISIT ON STAGED_VISIT.REGISTRANT_ID = REGISTRANT_VISIT.REGISTRANT_ID
                WHERE REGISTRANT_VISIT.REGISTRANT_VISIT_ID = REGISTRANT_HEALTH_FACTOR.REGISTRANT_VISIT_ID
                  AND STAGED_VISIT.EVALUATION_FLAG = 'Y');
                  
  PRINT 'Delete encouters being updated';

  DELETE 
  FROM AHOBPR.REGISTRANT_VISIT
  WHERE EVALUATION_FLAG = 'Y'
    AND EXISTS(SELECT REGISTRANT_ID FROM AHOBPR.STAGED_VISIT
                WHERE STAGED_VISIT.REGISTRANT_ID = REGISTRANT_VISIT.REGISTRANT_ID
                AND STAGED_VISIT.EVALUATION_FLAG = 'Y');

  PRINT 'Delete recent visits being updated';              

  DELETE 
  FROM AHOBPR.REGISTRANT_VISIT
  WHERE EVALUATION_FLAG = 'N'
    AND EXISTS(SELECT REGISTRANT_ID FROM AHOBPR.STAGED_VISIT
                WHERE STAGED_VISIT.REGISTRANT_ID = REGISTRANT_VISIT.REGISTRANT_ID
                AND STAGED_VISIT.EVALUATION_FLAG = 'N');               		      
  
  PRINT 'Set Institution ID in Staged VISIT';
  
  WITH Src
  AS(
  SELECT Stg.VisitSID
        ,Stg.INSTITUTION_CODE
        ,Inst.ID
    FROM [AHOBPR].[STAGED_VISIT] Stg
    JOIN AHOBPR.VIEW_INSTITUTION Inst ON Inst.STATIONNUMBER = Stg.INSTITUTION_CODE
    )
    MERGE INTO [AHOBPR].[STAGED_VISIT] AS Tgt
    USING Src
	   ON Tgt.VisitSID = Src.VisitSID
    WHEN MATCHED
    THEN UPDATE
		    SET Tgt.STD_INSTITUTION_ID = Src.ID;		    
		    
  PRINT 'Insert encounters and visits...';              

  INSERT INTO [AHOBPR].[REGISTRANT_VISIT]
             ([REGISTRANT_ID]
             ,[VISIT_DATE_TIME]
             ,[STD_INSTITUTION_ID]
             ,[VISTA_EncounterID]
             ,[VISTA_Sta3n]
             ,[VISTA_EligibilityStatus]
             ,[EVALUATION_FLAG]
             ,[APPOINTMENT_TYPE]
             ,[STOP_CODE]
             ,[CREATEDBY]
             ,[UPDATEDBY]
             ,[CREATED]
             ,[UPDATED])
      SELECT [REGISTRANT_ID]
            ,[VISIT_DATE_TIME]
            ,[STD_INSTITUTION_ID]
            ,[VISTA_EncounterID]
            ,[VISTA_Sta3n]
            ,[VISTA_Eligibility]
            ,[EVALUATION_FLAG]
            ,[APPOINTMENT_TYPE]
            ,[STOP_CODE]
            ,@ProcName
            ,@ProcName
            ,@Now
            ,@Now
    FROM [AHOBPR].[STAGED_VISIT];		    
 
  PRINT 'Set Standard Health Factors ID from STD_HEALTH_FACTOR...';  
    
  WITH Src
   AS(
      SELECT [CDW_VISIT_SID]
            ,[REGISTRANT_ID]
            ,std.[STD_HEALTH_FACTOR_ID]
            ,[HEALTH_FACTOR_TEXT]      
        FROM [AHOBPR].[STAGED_HEALTH_FACTOR] staged
        JOIN AHOBPR.STD_HEALTH_FACTOR std ON std.NAME = staged.HEALTH_FACTOR_TEXT
    )
    MERGE INTO AHOBPR.[STAGED_HEALTH_FACTOR] AS Tgt
    USING Src  ON Tgt.[CDW_VISIT_SID] = Src.[CDW_VISIT_SID]
    WHEN MATCHED
             AND Tgt.[REGISTRANT_ID] = Src.[REGISTRANT_ID]
             AND Tgt.[HEALTH_FACTOR_TEXT] = Src.[HEALTH_FACTOR_TEXT]
    THEN UPDATE
		    SET Tgt.[STD_HEALTH_FACTOR_ID] = Src.[STD_HEALTH_FACTOR_ID];
 
   PRINT 'Insert Health Factors...';  
   
  INSERT INTO [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
             ([REGISTRANT_VISIT_ID]
             ,[STD_HEALTH_FACTOR_ID]
             ,[ACTIVE_FLAG]
             ,[HEALTH_FACTOR_TEXT]
             ,[COMMENTS]
             ,[CREATEDBY]
             ,[UPDATEDBY]
             ,[CREATED]
             ,[UPDATED])          
      SELECT visit.REGISTRANT_VISIT_ID
            ,hf.[STD_HEALTH_FACTOR_ID]
            ,1
            ,hf.[HEALTH_FACTOR_TEXT]
            ,hf.[COMMENTS]
            ,@ProcName    
            ,@ProcName
            ,@Now
            ,@Now     
    FROM [AHOBPR].[STAGED_HEALTH_FACTOR] hf -- 295
    JOIN AHOBPR.STAGED_VISIT stage ON stage.VisitSID = hf.CDW_VISIT_SID
    JOIN AHOBPR.REGISTRANT_VISIT visit ON visit.VISTA_EncounterID = stage.VISTA_EncounterID 

END;
-- EXECUTE [AHOBPR].[SP_UpdateFromCDW]; 
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_LoadJsonQueue]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE PROCEDURE [AHOBPR].[SP_LoadJsonQueue]
AS

BEGIN

  -- DELETE any duplicate REGISTRANT_JSON rows
  WITH AllRows
  AS (
      SELECT [REGISTRANT_JSON_ID]
            ,[OBJECT_ID]
            ,[OBJECT_TYPE]
            ,RANK() OVER(PARTITION BY [OBJECT_TYPE], [OBJECT_ID]
                             ORDER BY [REGISTRANT_JSON_ID] DESC) AS RowRank
        FROM [AHOBPR].[REGISTRANT_JSON]
       )
  ,Duplicates 
     AS(
         SELECT [REGISTRANT_JSON_ID] 
           FROM AllRows
           WHERE RowRank > 1
        )
      DELETE FROM [AHOBPR].[REGISTRANT_JSON]
       WHERE EXISTS(SELECT * FROM Duplicates 
                     WHERE Duplicates.REGISTRANT_JSON_ID = [REGISTRANT_JSON].REGISTRANT_JSON_ID);
                     
  -- Insert the rest into JSON_QUEUE     
  WITH Src 
AS(SELECT [REGISTRANT_JSON_ID]
         ,[CREATED]
         ,[UPDATED]
         ,[CREATEDBY]
         ,[UPDATEDBY]
     FROM [AHOBPR].[REGISTRANT_JSON]
     )
     MERGE INTO [AHOBPR].[JSON_QUEUE] Tgt
     USING Src
        ON Tgt.[REGISTRANT_JSON_ID] = Src.[REGISTRANT_JSON_ID]
     WHEN NOT MATCHED
     THEN INSERT  
            ([REGISTRANT_JSON_ID]
            ,[CREATED]
            ,[UPDATED]
            ,[CREATEDBY]
            ,[UPDATEDBY])
            VALUES(
         Src.[REGISTRANT_JSON_ID]
        ,Src.[CREATED]
        ,Src.[UPDATED]
        ,Src.[CREATEDBY]
        ,Src.[UPDATEDBY]);
END

-- EXECUTE [AHOBPR].[SP_LoadJsonQueue]
GO
PRINT N'Inserting Change Log Record...';


GO


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('$(MajorReleaseNumber)'
           ,'$(MinorReleaseNumber)'
           ,'$(PointReleaseNumber)'
           ,0
           ,'Step 2 - Registry.Database.Deploy.sql'
		       ,'Initial Production Deployment of AHOBPR'
           ,'AHOBPR'
           ,GETDATE());


PRINT '';
PRINT 'Step 2 - Registry.Database.Deploy.sql Script Complete.';
PRINT '';
PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';

---------------------------------
-- END OF GENERATED DEPLOYMENT --
---------------------------------